function [keep] = hardtreshold(Yh,Yt,X,tc,p)
% Choisi quelles sries  inclure dans l'ACP avec le hardtresholding de Bai
% et Ng (2008) Journal of econometrics

% Y: Srie du in-sample (lui qui bouge l) (Y_1  Y_t-h+1) +1 pour itratio
% X: N variables  considrer pour l'ACP  (X_1  X_t-h+1) +1 pour itration
% tc: Valeur critique  dpasser
% h: horizon de la prvision
% p: nombre de lag de Y (Bai et Ng le fixent  4)
% X et Y suppos avoir le mme nombre de lignes

N = size(X,2);

[W,Wlag] = lagML2(Yt,p); 
W = [ones(size(W,1),1) W(:,1), Wlag(:,1:end-1)];
tval = zeros(1,N);

for n = 1:N
    [Xi,Xilag] = lagML2(X(:,n),1);  
    YWX = [Yh,W,Xi];
    YWX = YWX(~any(isnan(YWX),2),:);
    beta = YWX(:,2:end)\YWX(:,1);
    
    % Fit du sample
    par = size(YWX,2)-1;
    ttt = size(YWX,1);
            
    yin = YWX(:,2:end)*beta;
    res = YWX(:,1) - yin;
    sigma2 = res'*res/(ttt-par);   
    XX = inv(YWX(:,2:end)'*YWX(:,2:end));
    std = sqrt(sigma2*XX(end,end));
    
    t = abs(beta(end)/std);
    tval(1,n) = t;
end
    keep = find(tval > tc);
    
    
end

