% generate_freddata.m
% =========================================================================
% DESCRIPTION: 
% This script loads in raw data from FRED-MD_2015m1.csv, transforms each
% series based on transformation code using prepare_missing.m, and removes
% outliers from the transformed data using remove_outliers.m.
%
% =========================================================================
% CLEAR: 
clear all
close all
clc

% =========================================================================
% PARAMETERS TO BE CHANGED:
% Make sure these parameters match the final observation date from the .csv
% file

% Month of final observation (1=Jan, 2=Feb, etc.)
final_month=12; % December

% Year of final observation
final_year=2014; % 2014

% =========================================================================
% LOAD AND LABEL DATA: 
% Load data from file freddata.csv
dum=importdata('FRED-MD_2015m1.csv',',');

% Variable names
names=dum.textdata(1,2:end);

% Transformation numbers
tcode=dum.data(1,:);

% Raw data
rawdata=dum.data(2:end,:);

% =========================================================================
% SET UP DATES: 
% Dates (monthly) are of the form YEAR+MONTH/12
% e.g. March 1970 is represented as 1970+3/12
% Dates go from 1959:01 to final_year:final_month (see above)
dates = [1959+1/12:1/12:final_year+final_month/12]';

% T = number of months in sample
T=size(dates,1);
rawdata=rawdata(1:T,:);

% =========================================================================
% TRANSFORM RAW DATA INTO STATIONARY FORM: 
% Use function prepare_missing.m
%   Output yt: matrix containing data after transformation
yt=prepare_missing(rawdata,tcode);

% =========================================================================
% REDUCE SAMPLE TO USABLE DATES: 
% Remove first two months because some series have been second differenced
yt=yt(3:T,:);
dates=dates(3:T,:);

% =========================================================================
% REMOVE OUTLIERS: 
% Use function remove_outliers.m (see for definition of outliers)
%   Output data: matrix containing transformed series after removal of outliers
%   Output n: matrix containing number of outliers removed for each series
[data,n]=remove_outliers(yt);

% =========================================================================
% SAVE DATA TO .MAT FILE: 
% Save data, dates, names, and tcode to file freddata.mat
save freddata data dates names tcode ;