% FHLR Estimation of the dynamic factors
%
%
% nn: nombre de facteurs dynamiques
% nfactors: nb de facteurs statiques?
% M:Number of points where to estimate the spectral matrix
% x: normalis 
% Jean Boivin
% 7/17/04

function [dynfac,R,covc]  = fhlrfac(x, nfactors, nn, M)
T = size(x,1);
covc = cestimate(x,nfactors,M);
n = size(covc,3);
G = squeeze(covc(:,:,(n + 1)/2));
S = cov(x) - G;
options.disp=0;
[ R, D ] = eigs(G,diag(diag(S)),nn,'LM',options);
dynfac=x*R;
