% This function performs the sequential one-step ahead forecasts
% This is a more general formulation. It forecasts a single variable or a
% matrix.
% Last update: 04/03/2009

function [y_seq_fcst_h,sequence,A_hat,B_hat,u_bar,p_est,q_est,gamma_hat] = fcst_varma_sequential(y,p,q,h,const,delta,c_0,m_T,n_T,varma_rep)

% y is the variable to forecast
% p is the lag order of AR part
% q is the lag order of MA part
% h is the forecast horizon
% if const = 0, no constant term in regression
% if const = 1, there is a constant term in regression
% if const = 2, there are a constant term and trend
% y = Factors;
% p=pf_varma_diag_ma; q = qf_varma_diag_ma;

if max(p)==0 && max(q)==0
    if const==0
        y_seq_fcst_h = 0;
        sequence = zeros(size(y,2),h);
    elseif const==1
        y_seq_fcst_h = mean(y);
        sequence = repmat(mean(y)',1,h);
    end;
    beta = [];  
else
% if max(p)>0 && max(q)==0
% 
% % First, estimate the model :
% % y(t) = A(L)'y(t)+e(t) 
% % The model is estimated with data from 1 to T-h.
% 
% %y = F(1:T-h,:); p=3;
% % Construction of regressors matrix
% y_lags = mlag(y,max(p)); % this creates a matrix of (t,p) size
% y = y(max(p)+1:end,:);
% y_lags = y_lags(max(p)+1:end,:);
% [t,n] = size(y);
% 
% if n==1
%     if const==0
%         x = [y_lags];
%     elseif const==1
%         x = [ones(t,1) y_lags];
%     elseif const==2
%         trend = [1:t]';
%         x = [ones(t,1) y_lags trend];
%     end;
%     beta = inv(x'*x)*x'*y;  % OLS estimates
% 
%     % h-step-ahead forecast
%     % y_T+h|T = a_h + sum_j=1-m[beta_hj'*F_T-j+1] + sum_j=1-p[gamma_hj*y_T-j]
% 
%     if const==0
%         yy = mlag(y,max(p)-1);
%         y_pred = [y yy];
%     elseif const==1
%         yy = mlag(y,max(p)-1);
%         y_pred = [ones(t,1) y yy];
%     elseif const==2
%         yy = mlag(y,max(p)-1);
%         y_pred = [ones(t,1) y yy trend];
%     end;
% elseif n>1  % this becomes a VAR and n is the  number of equations
%     beta = [];
%     if const==0
%         for i=1:n
%             x = [y_lags];
%             b = inv(x'*x)*x'*y(:,i);
%             beta = [beta, b];
%         end;
%     elseif const==1
%         for i=1:n
%             y_lg = mlag(y(:,i),p(i));
%             x = [ones(t,1) y_lg];
%             b = inv(x'*x)*x'*y(:,i);
%             if p(i)==0
%                 b = [b; 0];
%             end
%             beta = [beta, b];
%         end;
%     elseif const==2
%         for i=1:n
%             x = [ones(t,1) y_lags trend];
%             b = inv(x'*x)*x'*y(:,i);
%             beta = [beta, b];
%         end;
%     end;
%     ff = [];
%     ff_lags = mlag(y,max(p)-1);
%     index = [1:max(p)-1:n*(max(p)-1)];
%     if max(p)==1
%         ff = y;
%     elseif max(p)>1
%         for i=1:size(index,2)
%             ff = [ff, y(:,i) ff_lags(:,index(i):index(i)+max(p)-1-1)];
%         end;
%     end;
%     if const==0
%         y_pred = [ff];
%     elseif const==1
%         y_pred = [ones(t,1) ff];
%     elseif const==2
%         y_pred = [ones(t,1) ff trend];
%     end;
% end;
% 
% % Obtain the starting point for forecasting
% % If h=1, this will be the forecasting result
% y_seq_fcst_1 = y_pred(t,:)*beta;  % this is X_hat(i,T+1|T)
% y = [y; y_seq_fcst_1];
% 
% % Form the sequence of h one-step-ahead forecasts
% sequence = [];
% sequence = [sequence, y_seq_fcst_1'];
% 
% if h==1
%     y_seq_fcst_h = y_seq_fcst_1;
%     sequence = sequence;
% elseif h>1
%     for i=1:h-1  % at the end, i=h-1, we obtain X_hat(i,T+h|T)
%         y_h = onestepahead_fcst(y,max(p),beta,const);
%         y = [y; y_h];
%         sequence = [sequence, y_h'];  % the last line of sequence is T+h forecast
%     end;
%     y_seq_fcst_h = y_h;
%     %sequence = mlag(y,max(p));
% end;

% 
% elseif max(q)>0
    
    y = y';
    [n,t] = size(y);
    
    if varma_rep==1
    %%% VARMA DIAG MA on FactorsY
    [gamma_hat,A_hat,B_hat,u_bar,p_est,q_est]  = varma_estimaton_diag_ma_orders(y,delta,c_0,m_T,[],[],n_T,p,q,0);
    
    y_fcst_diag_ma = [y, zeros(n,h)];
    u_bar_fcst_diag_ma = [u_bar, zeros(n,h)];
    
    for j=1:h       
        for i=1:max(p)
            y_fcst_diag_ma(:,t+j) = y_fcst_diag_ma(:,t+j) + A_hat{i}*y_fcst_diag_ma(:,t-i+j);
        end
        for i=1:max(q)
            y_fcst_diag_ma(:,t+j) = y_fcst_diag_ma(:,t+j) - B_hat{i}*u_bar_fcst_diag_ma(:,t-i+j);
        end
        
%         u_bar_fcst_diag_ma(:,t+j) = y_fcst_diag_ma(:,t+j);
%         for i=1:max(p)
%             u_bar_fcst_diag_ma(:,t+j) = u_bar_fcst_diag_ma(:,t+j) - A_hat{i}*y_fcst_diag_ma(:,t-i+j);
%         end
%         for i=1:max(q)
%             u_bar_fcst_diag_ma(:,t+j) = u_bar_fcst_diag_ma(:,t+j) + B_hat{i}*u_bar_fcst_diag_ma(:,t-i+j);
%         end 
    end
    y_seq_fcst_h = y_fcst_diag_ma(:,end);
    sequence = y_fcst_diag_ma(:,end-h+1:end);
    
    elseif varma_rep==2
    %%% VARMA DIAG AR on FactorsY
    [gamma_hat,A_hat,B_hat,u_bar,p_est,q_est]  = varma_estimaton_diag_ar_orders(y,delta,c_0,m_T,[],[],n_T,p,q,0);
    
    y_fcst_diag_ar = [y, zeros(n,h)];
    u_bar_fcst_diag_ar = [u_bar, zeros(n,h)];
    
    for j=1:h       
        for i=1:max(p)
            y_fcst_diag_ar(:,t+j) = y_fcst_diag_ar(:,t+j) + A_hat{i}*y_fcst_diag_ar(:,t-i+j);
        end
        for i=1:max(q)
            y_fcst_diag_ar(:,t+j) = y_fcst_diag_ar(:,t+j) - B_hat{i}*u_bar_fcst_diag_ar(:,t-i+j);
        end
        
%         u_bar_fcst_diag_ar(:,t+j) = y_fcst_diag_ar(:,t+j);
%         for i=1:max(p)
%             u_bar_fcst_diag_ar(:,t+j) = u_bar_fcst_diag_ar(:,t+j) - A_hat{i}*y_fcst_diag_ar(:,t-i+j);
%         end
%         for i=1:max(q)
%             u_bar_fcst_diag_ar(:,t+j) = u_bar_fcst_diag_ar(:,t+j) + B_hat{i}*u_bar_fcst_diag_ar(:,t-i+j);
%         end 
    end
    y_seq_fcst_h = y_fcst_diag_ar(:,end);
    sequence = y_fcst_diag_ar(:,end-h+1:end);
    
    elseif varma_rep==3
    %%% VARMA FINAL MA on FactorsY
    [gamma_hat,A_hat,B_hat,u_bar,p_est,q_est]  = varma_estimaton_final_ma_orders(y,delta,c_0,m_T,[],[],n_T,p,q,0);
    
    y_fcst_final_ma = [y, zeros(n,h)];
    u_bar_fcst_final_ma = [u_bar, zeros(n,h)];
    
    for j=1:h       
        for i=1:max(p)
            y_fcst_final_ma(:,t+j) = y_fcst_final_ma(:,t+j) + A_hat{i}*y_fcst_final_ma(:,t-i+j);
        end
        for i=1:max(q)
            y_fcst_final_ma(:,t+j) = y_fcst_final_ma(:,t+j) - B_hat{i}*u_bar_fcst_final_ma(:,t-i+j);
        end
        
%         u_bar_fcst_final_ma(:,t+j) = y_fcst_final_ma(:,t+j);
%         for i=1:max(p)
%             u_bar_fcst_final_ma(:,t+j) = u_bar_fcst_final_ma(:,t+j) - A_hat{i}*y_fcst_final_ma(:,t-i+j);
%         end
%         for i=1:max(q)
%             u_bar_fcst_final_ma(:,t+j) = u_bar_fcst_final_ma(:,t+j) + B_hat{i}*u_bar_fcst_final_ma(:,t-i+j);
%         end 
    end
    y_seq_fcst_h = y_fcst_final_ma(:,end);
    sequence = y_fcst_final_ma(:,end-h+1:end);
    
    elseif varma_rep==4
    %%% VARMA FINAL AR on FactorsY
    [gamma_hat,A_hat,B_hat,u_bar,p_est,q_est]  = varma_estimaton_final_ar_orders(y,delta,c_0,m_T,[],[],n_T,p,q,0);
    
    y_fcst_final_ar = [y, zeros(n,h)];
    u_bar_fcst_final_ar = [u_bar, zeros(n,h)];
    
    for j=1:h       
        for i=1:max(p)
            y_fcst_final_ar(:,t+j) = y_fcst_final_ar(:,t+j) + A_hat{i}*y_fcst_final_ar(:,t-i+j);
        end
        for i=1:max(q)
            y_fcst_final_ar(:,t+j) = y_fcst_final_ar(:,t+j) - B_hat{i}*u_bar_fcst_final_ar(:,t-i+j);
        end
        
%         u_bar_fcst_final_ar(:,t+j) = y_fcst_final_ar(:,t+j);
%         for i=1:max(p)
%             u_bar_fcst_final_ar(:,t+j) = u_bar_fcst_final_ar(:,t+j) - A_hat{i}*y_fcst_final_ar(:,t-i+j);
%         end
%         for i=1:max(q)
%             u_bar_fcst_final_ar(:,t+j) = u_bar_fcst_final_ar(:,t+j) + B_hat{i}*u_bar_fcst_final_ar(:,t-i+j);
%         end 
    end
    y_seq_fcst_h = y_fcst_final_ar(:,end);
    sequence = y_fcst_final_ar(:,end-h+1:end);
    
    end; %% varma_rep
      
end;

