

function  [p_est,q_est] = estim_orders_varma_final_ar(y,delta,c_0,m_T,max_p,max_q,n_T)

% -----------------------------------------------------
%             VARMA FINAL AR FORM ESTIMATION
% -----------------------------------------------------

% INPUTS:
% y      - KxT series
% delta  -
% c_0    -
% m_T    -
% max_p  - maximum AR lag order (1x1)
% max_q  - maximum MA lag order (1x1)
% n_T    - long VAR order


[K,T] = size(y);

nb_par = max_q+max_p*K^2;
big_P = max_p;
big_Q = max_q;

matrix_critere = zeros(big_P+1, big_Q+1);

    % Step 1
  [pi_hat,u_hat] = step1(y, n_T);
  
  % Selection of p and q
  for i=0:big_P
    for j=0:big_Q
      if ( ((i==0) && (j==0)) )
        matrix_critere(1+i,1+j) = log(det((y * y') /T));
        %mat_denis(jjj,1+i,1+j) = log(det((y * y') /T));
      else
        [gamma_tilde,critere,A_tilde,B_tilde] = step2_final_AR(y,n_T,u_hat,i,j,delta,c_0);
        matrix_critere(1+i,1+j) = critere(1);
        %mat_denis(jjj,1+i,1+j) = critere(2);
      end
    end
  end
  
  [tutu,q_opt] = min(min(matrix_critere));
  [tutu,p_opt] = min(min(matrix_critere'));
  
  % Estimates of p and q are
    p_est = p_opt-1;
    q_est = q_opt-1;

