

function  [p_est,q_est] = estim_orders_varma_diag_ar(y,delta,c_0,m_T,max_p,max_q,n_T)

% -----------------------------------------------------
%   VARMA DIAGONAL AR FORM: estimation of lag orders
% -----------------------------------------------------

% INPUTS:
% y      - KxT series
% delta  -
% c_0    -
% m_T    -
% max_p  - maximum AR lag order (Kx1)
% max_q  - maximum MA lag order (1x1)
% n_T    - long VAR order

[K,T] = size(y);

nb_par = sum(max_p)+max_q*K^2;
big_P = max_p;
big_Q = max_q;

  % Step 1
  [pi_hat,u_hat] = step1(y, n_T);

  % Selection of p and q
  p_opt = zeros(K, 1);
  q_opt = zeros(K, 1);
  
  for k=1:K
    matrix_critere = zeros(big_P(k)+1, big_Q+1);
    
    for i=0:big_P(k)
      for j=0:big_Q
        if ( ((i==0) && (j==0)) )
          matrix_critere(1+i,1+j) = log((y(k,:) * y(k,:)') /T);
          %mat_denis(jjj, k, i+1, j+1) = log((y(k,:) * y(k,:)') /T);
        else
          [gamma_tilde,critere] = step2_diagonal_AR_k(y,n_T,u_hat,i,j,k,delta,c_0);
          matrix_critere(i+1,j+1) = critere(1);
          %mat_denis(jjj,k, i+1, j+1) = critere(2);
        end
      end
    end
    [tutu,q_opt(k)] = min(min(matrix_critere));
    [tutu,p_opt(k)] = min(min(matrix_critere'));
  end
  
  % Estimates of p and q are
    p_est = p_opt-ones(K,1);
    q_est = max(q_opt)-1;
  
