%
%
function S = cestimate(x,nfactors,w)
%x = center(x);
% define some useful quantities
[T,N] = size(x);
W = 2*w+1;
B = triang(W);
% compute covariances
S = zeros(N,N,W);
for k = 1:w+1,
     S(:,:,w+k) = B(w+k)*center(x(k:T,:))'*center(x(1:T+1-k,:))/(T-k);
     S(:,:,w-k+2) = S(:,:,w+k)';
end
% compute the spectral matrix in W points (S)
Factor = exp(-sqrt(-1)*(-w:w)'*(0:2*pi/W:4*pi*w/W));
for j = 1:N
   S(j,:,:) = squeeze(S(j,:,:))*Factor;
end
% compute the egenvectors  for all points (E) 
[A,D] = eigs(S(:,:,1),nfactors);
S(:,:,1) = A*D*A'; 
for j = 2:w+1,
   [A,D] = eigs(S(:,:,j),nfactors);
   S(:,:,j) = A*D*A'; 
   S(:,:,W+2-j) = conj(S(:,:,j));
 end
 for j = 1:N
    S(:,j,:) = real(squeeze(S(:,j,:))*conj(Factor).'/W);
end

