function [SubForc,disp,density_forc]=SubsetRegression_ML(X,y,Yl,xfor,Ylfor,kk,Draws,pmax,Density)

%  Function to compute complete subset regressions forecasts, described in the paper:
%  Elliott G., Gargano A. and Timmermann A., "Complete Subset Regressions", Journal of Econometrics (2013).

% Modification pour uniquement large K et un k � la fois. �galement ajout
% des lags de y.
% Maxime Leroux, 24 mars 2015
%
% INPUTS:   y,   a T-1 x 1 vector containing the target variable (from t=2 to t=T)
%           X,   a T-1 x K matrix of (lagged) predictors            (from t=1 to t=T-1)
%           yl,  lag de y (from t=1 to t=T-1)
%           xfor,a 1xK vector containing the predictors at t=T  (used to compute the out-of-sample forecasts)
%           ylfor, complete vector of right side transformation of y_t, used to compute lagged value for the forecast  
%  
%           kk, nombre de variables par mod�le
%           Draws, nombre de mod�les utilis�
%
% OUTPUTS:  
%                LARGE K
%           
%           SubForc a Max_k+1 x 1 vector containing the the out-of-sample forecasts   (from k=0 to k=Max_k)
%           SubBeta a Max_k+1 x K+1 matrix containing the the Subset Coefficients     (from k=0 to k=Max_k)
%
%  � Antonio Gargano, 25 June 2013
%  antonio_gargano@hotmail.com
% 

%warning('off','all');
Kd = length(Density);
K=size(X,2);
intercept=ones(length(y),1); 

   %%%% Initialize the variables
    %SubBeta=zeros(Max_k+1, K+1);        %initialize the Max_k x K+1 matrix containing the subset coefficients
    
    %%%% Compute Subset Forecasts and Coefficients
    %(This part of the code can run faster by using the 'parfor' instead of the 'for' loop - see the Parallel Toolbox manual)
    
    %disp(['k= ' num2str(k)])
    
      if  kk==0
      Models=zeros(1,K);  %the random draws are not needed
      elseif kk==1
      Models=eye(K);      %the random draws are not needed    
      elseif kk==K
      Models=ones(1,K);   %the random draws are not needed    
      else 
          
       % Random draws
        tModels=zeros(Draws,K);   
         for ii=1:size(tModels,1)
         ttmodel=tModels(ii,:);
         ttmodel(randsample(K,kk,false))=1;
         tModels(ii,:)=ttmodel;
         end
        Check=bi2de(tModels);
        [junk1,ind,junk2] = unique(Check);
        
        Models=tModels(ind,:);   
      end  
       
      
 
    Forc=NaN(size(Models,1),1);
    Dens = NaN(size(Models,Kd));
    
      parfor i=1:size(Models,1)
         
      model=find(Models(i,:));
        
      allB = cell(pmax,1);
      BIC = zeros(pmax,1);
      sigma2 = NaN(pmax,1);
      for p = 1:pmax
          
         [YYl,YYlag] = lagML2(Yl,p); 
          YYl = [YYl, YYlag(:,1:end-1)];
          XX = [intercept X(:,model) YYl];
          YX = [y XX];
          YX = YX(~any(isnan(YX),2),:);  
          
     
          Beta=YX(:,2:end)\YX(:,1);     %OLS coefficients
          
          
          allB{p,1} = Beta;
          
          % Fit du in-sample
          par = size(YX,2)-1;
          ttt = size(YX,1);

          yin = YX(:,2:end)*Beta;
          res = YX(:,1) - yin;
          sigma2(p) = res'*res/(ttt-par);

          % Calcul des crit�res d'information
          BIC(p,1) = log(sigma2(p))+ par*log(ttt)/ttt;
      end    
      
          
      
    if pmax == 1
        best_p = 1;
    else
        [C,I]   = min(BIC);
        P = ind2sub(size(BIC),I);
        best_p  = P;
    end
      
      Beta = allB{best_p,1};
      sigma = sqrt(sigma2(best_p));
      
      % lag de y
      [YYl,YYlag] = lagML2(Ylfor,best_p); 
       YYl = [YYl, YYlag(:,1:end-1)];
       YYl = YYl(end,:);
      
       Forc(i,1)=[1 xfor(:,model) YYl]*Beta;


      for dd = 1:Kd
          Dens(i,dd) = Forc(i,1)+Density(dd)*sigma;
      end       
       
       
      
   
      end
      
      
    SubForc=mean(Forc,1);
    disp = std(Forc,1);
    density_forc = mean(Dens,1);
    
    warning('ON','all');
end



