function [Y_hat,eps,Fnumber,optilag,Yhat_density] = SWtstat(Y,W1,W2,W3,h,Pmax,Kmax1,Kmax2,Kmax3,R,tc,rollwind,tcode,Density)
% Fait une analyse out-of-sample avec un mod�le � diffusion index

% INPUT
% Y: Variable � pr�dire
% W: En semble de donn�es T x K
% h: horizon de la pr�vision
% Pmax: nombre maximal de retard de la variable � pr�voir
% Mmax: nombre de retard des facteurs
% Kmax: nombre maximal de facteurs
% R: Taille de la fen�tre d'estimation
% tcode: Type de pr�vision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))


% OUTPUT
% MSPE: Moyenne des erreurs de pr�vision au carr�
% MAPE: Moyenne des erreurs de pr�vision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)
% Yhat: T-R pr�vision de la variable d'int�r�t
% eps: erreur de pr�vision


% Transformation selon tcode
if tcode == 1
    Yg = Y; % Y_1 � Y_t-h+1
    Yd = Y; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 2  
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(Y)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 3
    Yg = (Y(h+1:end)-Y(1:end-h))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(Y,2)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 4
    Yg = log(Y); % Y_1 � Y_t-h+1
    Yd = log(Y); % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 5  
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(log(Y))]; % Y_1 � Y_t-h+1
    drop = 2;
else
    Yg = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(log(Y),2)]; % Y_1 � Y_t-h+1
    drop = 2;
end



if size(W2,1) == 0
    nbase = 1;
elseif size(W3,1) == 0
    nbase = 2;
else
    nbase = 3;
end
    
    
T = size(Y,1);
Out_s = T-R;
Kd = length(Density);



% Keep y real values for the prediction error
real_y = Yg(R+1:end);


% Output object
Y_hat = zeros(Out_s,1);
Yhat_density = NaN(Out_s,length(Density));


% Keep information about factor
Fnumber = zeros(Out_s,1);
optilag = zeros(Out_s,1);


% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les derni�res h obs h p�riode en avance, avec h = 1, 1:R pour pr�voir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    
    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le le nombre d'obs manquantes d�pend de l'it�ration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs � dropper ne d�pend pas de l'it�ration dans le cas d'expending
    end
    
    YYg = Yg(dataRange,1); % Y_1 � Y_t-h+1
    YYd = Yd(dataRange,1); % Y_1 � Y_t-h+1
    
    allB = cell(Pmax);
    
    if nbase == 1
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        WW1 = WW1(:,~any(isnan(WW1),1));
        WW1 = unique(WW1','rows');
        WW1 = WW1';
        
    elseif nbase == 2
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        WW1 = WW1(:,~any(isnan(WW1),1));
        WW1 = unique(WW1','rows');
        WW1 = WW1';
        
        WW2 = W2(dataRange,:);
        WW2 = WW2(1+drop1:end,:);
        WW2 = WW2(:,~any(isnan(WW2),1));
        WW2 = unique(WW2','rows');
        WW2 = WW2';

    else
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        WW1 = WW1(:,~any(isnan(WW1),1));
        WW1 = unique(WW1','rows');
        WW1 = WW1';
        
        WW2 = W2(dataRange,:);
        WW2 = WW2(1+drop1:end,:);
        WW2 = WW2(:,~any(isnan(WW2),1));
        WW2 = unique(WW2','rows');
        WW2 = WW2';
        
        WW3 = W3(dataRange,:);
        WW3 = WW3(1+drop1:end,:);
        WW3 = WW3(:,~any(isnan(WW3),1));
        WW3 = unique(WW3','rows');
        WW3 = WW3';

    end
    
    

    if nbase == 1
        [ehat1,f1,lambda1,ss1]=pc(zscore(WW1),Kmax1);
    elseif nbase == 2
        [ehat1,f1,lambda1,ss1]=pc(zscore(WW1),Kmax1);
        [ehat2,f2,lambda2,ss2]=pc(zscore(WW2),Kmax2);
    else
        [ehat1,f1,lambda1,ss1]=pc(zscore(WW1),Kmax1);
        [ehat2,f2,lambda2,ss2]=pc(zscore(WW2),Kmax2);
        [ehat3,f3,lambda3,ss3]=pc(zscore(WW3),Kmax3);
    end

    BIC = zeros(Pmax,1);  
    sigma2 = NaN(Pmax,1);
    
if nbase == 1  % Cas avec un seul ensemble de donn�es pour facteurs 
    
    
    % Choix des facteurs
    Ylag = YYd(1+drop1:end-h,1);
    YYY = YYg(h+1+drop1:end,1);
    F1 = f1(1:end-h,:);
    
    % Ce que le lag de Y et une constante n'explique pas de Y
        betaY = [ones(size(Ylag,1),1) Ylag]\YYY;
        MyY = YYY - [ones(size(Ylag,1),1) Ylag]*betaY;

    % obtenir ce que les lag de Y et la constante ne pr�dit pas de F
        betaF = [ones(size(Ylag,1),1) Ylag]\F1;  
        MyF = F1 - [ones(size(Ylag,1),1) Ylag]*betaF; % ce que les lags de Y ne pr�disent pas, ni la constante
    
    % R�gression de MyY sur MyF
        Betaa = MyF\MyY;
        
    % tstat
    [ttt,kkk]= size(MyF);
        
         res = MyY-MyF*Betaa;
      sigma2 = res'*res/(ttt-kkk);  
       invXX = inv(MyF'*MyF);
       
       
       st = sqrt(sigma2*diag(invXX));
         tval = abs(Betaa./st);
       
    
    % Quels facteurs
    keepf = find(tval' > tc);
        
    
    % Les bons facteurs
    goodF = f1(:,keepf);
   
elseif nbase == 2
    
    % Choix des facteurs
    Ylag = YYd(1+drop1:end-h,1);
    YYY = YYg(h+1+drop1:end,1);
    F1 = f1(1:end-h,:);
    F2 = f2(1:end-h,:);
    
    % Ce que le lag de Y et une constante n'explique pas de Y
        betaY = [ones(size(Ylag,1),1) Ylag]\YYY;
        MyY = YYY - [ones(size(Ylag,1),1) Ylag]*betaY;

    % obtenir ce que les lag de Y et la constante ne pr�dit pas de F
        betaF = [ones(size(Ylag,1),1) Ylag]\[F1 F2];  
        MyF = [F1 F2] - [ones(size(Ylag,1),1) Ylag]*betaF; % ce que les lags de Y ne pr�disent pas, ni la constante
    
    % R�gression de MyY sur MyF
        Betaa = MyF\MyY;
        
    % tstat
    [ttt,kkk]= size(MyF);
        
         res = MyY-MyF*Betaa;
      sigma2 = res'*res/(ttt-kkk);  
       invXX = inv(MyF'*MyF);
       
       st = sqrt(sigma2*diag(invXX));
         tval = abs(Betaa./st);
         
    % Quels facteurs
    keepf = find(tval' > tc);
        
    
    % Les bons facteurs
    F = [f1,f2];
    goodF = F(:,keepf);
    
    
else    
    
    % Choix des facteurs
    Ylag = YYd(1+drop1:end-h,1);
    YYY = YYg(h+1+drop1:end,1);
    F1 = f1(1:end-h,:);
    F2 = f2(1:end-h,:);
    F3 = f3(1:end-h,:);
    
    % Ce que le lag de Y et une constante n'explique pas de Y
        betaY = [ones(size(Ylag,1),1) Ylag]\YYY;
        MyY = YYY - [ones(size(Ylag,1),1) Ylag]*betaY;

    % obtenir ce que les lag de Y et la constante ne pr�dit pas de F
        betaF = [ones(size(Ylag,1),1) Ylag]\[F1 F2 F3];  
        MyF = [F1 F2 F3] - [ones(size(Ylag,1),1) Ylag]*betaF; % ce que les lags de Y ne pr�disent pas, ni la constante
    
    % R�gression de MyY sur MyF
        Betaa = MyF\MyY;
        
    % tstat
    [ttt,kkk]= size(MyF);
        
         res = MyY-MyF*Betaa;
      sigma2 = res'*res/(ttt-kkk);  
       invXX = inv(MyF'*MyF);
       
       std1 = sqrt(sigma2*diag(invXX));
         tval = abs(Betaa./std1);
    % Quels facteurs
    
    keepf = find(tval' > tc);
        
    
    % Les bons facteurs
    F = [f1,f2,f3];
    goodF = F(:,keepf);
    
end

    for p = 1:Pmax  
       
        [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
         XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                            %  lag 1        lag 2          lag 3              lag p   
          
        % On perd les obs selon drop1
        XX = XX(1+drop1:end,:);                                   
                                            
                                            
        [fsl1,fsllag1] = lagML2(goodF(1:end-h,:),1); 
        fsl1 = [fsl1,fsllag1(:,1:end-1*size(keepf,2))];  % F_{t-2h+1} F_{t-2h+1-1} ...

        % Cr�ation de la matrice de variables "ind�pendantes"
        XXX = [ones(size(fsl1,1),1),XX,fsl1];
        YX = [YYg(h+1+drop1:end,1),XXX];
        YX = YX(~any(isnan(YX),2),:);

        % R�gression
        beta = YX(:,2:end)\YX(:,1);
        allB{p} = beta;

        % Fit du in-sample
        par = size(XXX,2);
        ttt = size(YX,1);

        yin = YX(:,2:end)*beta;
        res = YX(:,1) - yin;
        sigma2(p) = res'*res/(ttt-par);

        % Calcul des crit�res d'information
        BIC(p,1) = log(sigma2(p))+ par*log(ttt)/ttt;
            
        
    end
    
    minimum = min(BIC);
    
    
    [P] = ind2sub(size(BIC),find(BIC==minimum));
    best_p  = P;
            
           
      % Cr�ation des variables "ind�pendantes" pour la pr�vision
      % Retard de Y
      
      [y,ylag] = lagML2(YYd,best_p);    
      y = [y(:,1),ylag(:,1:end-1)];
      y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)
      
      
      % Retard de F
      [FF1,FFlag1] = lagML2(goodF,1);
      FF1 = [FF1,FFlag1(:,1:end-1*size(goodF,2))];
      FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      % Variables pr�dictives
      lastx = [1,y,FF1];
      
      % on prend le bon beta
      fbeta = allB{best_p};
      
      % Pr�vision
      Y_hat(tt,1) = lastx*fbeta;
      
      sigma = sqrt(sigma2(best_p));
      
            
      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end

      
      
      Fnumber(tt,1) = size(goodF,2);
      optilag(tt,1) = best_p;
      
      
      
  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+tt;
  end

end
  

eps  = real_y-Y_hat; 


end

