function [Y_hat,eps] = RWD_forecast(Y,h,R,rollwind,tcode)
% Use a random walk with drfit model to forecast an I(1) variable.
% This means that the model is actually a model with only a constant.

% Input:
% Y: Variable to forecast
% h: Horizon of the forecast
% R: Size of the estimation window
% rollwind: What type of window to use
%   1: Rolling
%   2: Expanding
% tcode: Transformation code
%           2: (y_t-y_{t-h})/h
%           5: (ln(y_t)-ln(y_{t-h}))/h



% Output:
% Y_hat: Forecasts
% eps: Forecast errors


[MSPE,MAPE,Y_hat,eps] = meanforecast(Y,R,h,rollwind,tcode);


end

