function [Y2h] = I2toI2h(Y2,Y,h)
% Y2: Valeur prdite de diff2(Y) (\Delta^2 Y_{t+h}) (hx1)
%  Y: Deux dernires obs disponibles (2x1)
%  h: horizon de la prvision



%Y2h: \Delta^2 \hat{Y}_{t+h}^h = (\hat{Y}_{t+h}-Y_t)/h - (Y_t - Y_{t-1}))
% Il faut donc construire \hat{Y}_{t+h} avec:
% \Delta^2 \hat{Y}_{t+h} = (\hat{Y}_{t+h} - \hat{Y}_{t+h-1}) - (\hat{Y}_{t+h-1} - \hat{Y}_{t+h-1-1})
% On doit alors galement constuire les retards de \hat{Y}_{t+h} jusqu':
% \Delta^2 \hat{Y}_{t+1} = (\hat{Y}_{t+1} - Y_t) - (Y_t - Y_{t-1})
%  la premire itration on a uniquement une inconnue.


yhat = NaN(h,1);
Ylag = Y';     % Y_{t-1}  Y_{t}

% ici c'est bon pour h = 1 Y2 = Y2h
for ii = 1:h
    yhat(ii,1) = Y2(ii,1)+2*Ylag(1,2)-Ylag(1,1);
    Ylag = [Ylag(1,2) yhat(ii,1)];
end

Y2h = (yhat(end,1)-Y(end,1))/h - (Y(end,1)-Y(end-1,1));

end

