function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat_k,eps,Dispersion] = GRSR(W,Y,Pmax,Max_Draws,KK,K,h,R,rollwind,tcode,G_type,Density)

% Guided random subset regression
% We use either Lasso or tstats to restrict the number of series in the panel used to choose the series to use. 

% INPUT
% Y: Variable � pr�dire
% X: lot de variables
% h: horizon de la pr�vision
% pmax: lag maximal de Y
% Max_Draws: Maximum number of model to estimate
% G_type: Guiding methodology (1 for soft tresholding and 2 for hard tresholding)
% KK: number of series in the guided panel or tstat for hard treshold

% R: Taille de la fen�tre d'estimation
% rollwind: Type de fen�tre
%           1: glissante
%           2: croissante
% tcode: Type de pr�vision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))



% OUTPUT
% MSPE: Moyenne des erreurs de pr�vision au carr�
% MAPE: Moyenne des erreurs de pr�vision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)

% Yhat: T-R pr�vision de la variable d'int�r�t
% eps: erreur de pr�vision

% � noter: Plus le nombre de r�gresseurs augmentent, plus la probabilit� de
% multicolin�arit� imparfaite (probl�me de rang) augmente. Lorsqu'un tel
% probl�me survient X/Y supprime automatiquement la variable probl�matique
% et fixe son beta � 0. Il n'y a a donc pas toujours kk variables par mod�le


% Transformation selon tcode
if tcode == 1
    Yg = Y; % Y_1 � Y_t-h+1
    Yd = Y; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 2  
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(Y)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 3
    Yg = (Y(h+1:end)-Y(1:end-h))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(Y,2)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 4
    Yg = log(Y); % Y_1 � Y_t-h+1
    Yd = log(Y); % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 5  
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(log(Y))]; % Y_1 � Y_t-h+1
    drop = 2;
else
    Yg = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(log(Y),2)]; % Y_1 � Y_t-h+1
    drop = 2;
end



T = size(Y,1);
Out_s = T-R;
Kd = length(Density);

% Keep y real values for the prediction error
real_y = Yg(R+1:end);


% Output object
Y_hat_k = NaN(Out_s,1);
Dispersion = NaN(Out_s,1);
Yhat_density = NaN(Out_s,length(Density));

% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les derni�res h obs h p�riode en avance, avec h = 1, 1:R pour pr�voir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
   
    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le le nombre d'obs manquantes d�pend de l'it�ration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs � dropper ne d�pend pas de l'it�ration dans le cas d'expending
    end
    
    YYg = Yg(dataRange,1); % Y_1 � Y_t-h+1
    YYd = Yd(dataRange,1); % Y_1 � Y_t-h+1
    YYd = YYd(1+drop1:end,:);
    
    WW1 = W(dataRange,:);
    WW1 = WW1(1+drop1:end,:);
    WW1 = WW1(:,~any(isnan(WW1),1));
    WW1 = unique(WW1','rows');
    WW1 = WW1';
    WW1 = zscore(WW1);
   
    
    if G_type == 1
        keep = softreshold(YYg(1+drop1+h:end),YYd(1:end-h,1),WW1(1:end-h,:),1,KK);
    else
        keep = hardtreshold(YYg(1+drop1+h:end),YYd(1:end-h,1),WW1(1:end-h,:),KK,1);
    end
   
    WW = WW1(:,keep);
    if length(keep) <= 3 %if it picks 3 or less series use all one series models
        K1 = 1; 
    elseif length(keep) <= K % if it picks exactly or less than K series (we want all K series models, instead we'll have all K-3 series models)
        K1 = length(keep)-3;
    else
        K1=K;
    end
    
    if length(keep) > 0

        % Setting the maximum number of draws based on kk and the number of
        % series kept
        tot = factorial(size(WW,2))/(factorial(K1)*factorial(size(WW,2)-K1));
        if tot <= Max_Draws
            Draws = tot;
        else
            Draws = Max_Draws;
        end

        [SubForc,disp,density_forc]=SubsetRegression_ML(WW(1:end-h,:),YYg(h+1+drop1:end,1),YYd(1:end-h,1),WW(end,:),YYd,K1,Draws,Pmax,Density);
        Y_hat_k(tt,1) = SubForc;
        Dispersion(tt,1) = disp;
        %Yhat_density(tt,:) = density_forc;
    else
        
        
    allB = cell(Pmax,1);
    BIC = zeros(Pmax,1);
    sigma2 = NaN(Pmax,1);
     for p = 1:Pmax  
      
       [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
        XX = [XX, XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
        
                                      %  lag 1        lag 2          lag 3              lag p
        
    
        
        % Cr�ation de la matrice de variables "ind�pendantes" et d�pendante
        
        XXXX = [ones(size(XX,1),1),XX];
        YX = [YYg(h+1+drop1:end,1),XXXX];   
        YX = YX(~any(isnan(YX),2),:);  
          
        % R�gression
        beta = YX(:,2:end)\YX(:,1);
        allB{p,1} = beta;  %cr�er avant pour la vitesse
                
        % Fit du in-sample
        par = size(XXXX,2);
        ttt = size(YX,1);
            
        yin = YX(:,2:end)*beta;
        res = YX(:,1) - yin;
        sigma2(p,1) = res'*res/(ttt-par);
                
        % Calcul des crit�res d'information
        BIC(p,1) = log(sigma2)+ par*log(ttt)/ttt;
            
    end
    
    
    if Pmax == 1
        best_p = 1;
    else
        [C,I]   = min(BIC);
        P = ind2sub(size(BIC),I);
        best_p  = P;
    end
     
      % Cr�ation des variables "ind�pendantes" pour la pr�vision
      % Retard de Y
    
      [y,ylag] = lagML2(YYd,best_p);    
      y = [y(:,1),ylag(:,1:end-1)];
      y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)
    
      % Variables pr�dictives
      lastx = [1,y];
      
      % on prend le bon beta
      fbeta = allB{best_p,1};
      
      
      % Forecast error variance
      sigma = sqrt(sigma2(best_p));
      
      
      % Pr�vision
      Y_hat_k(tt,1) = lastx*fbeta;    
      Dispersion(tt,1) = 0;  
      
      
    end
    
      if rollwind == 1
          dataRange = dataRange +1;
      elseif rollwind == 0
          dataRange = 1:R-h+1+tt;
      end
      
end
  

eps  = real_y-Y_hat_k; 

% Calcul des m�triques

% M�triques de base
MSPE = mean(eps.^2);
MAPE = mean(abs(eps));

% Coefficients de Theil
THEIL  = sqrt(MSPE)./(sqrt(mean(Y_hat_k.^2))+sqrt(mean(real_y.^2)));
Tbiais = ((mean(Y_hat_k)-mean(real_y)).^2)./MSPE;
Tvar   = ((std(Y_hat_k)-std(real_y)).^2)./MSPE;


Tcov = (2*(1-corr(Y_hat_k,real_y))*std(Y_hat_k)*std(real_y))/MSPE;



%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diff�rence)
if tcode == 1 | tcode == 4
    Sign = NaN;
else
    
    
    
n = size(real_y,1);

[real_pos,junk] = find(real_y>0);

[pred_pos,junk] = find(Y_hat_k>0);
[positive,junk] = find(real_y>0 & Y_hat_k>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);



end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y,R,h,rollwind,tcode);
PR2 = 1 - MSPE./MSPEmean;



end

