function [Y_h] = Forecast_trans(Y,h,R,tcode)

%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))




% Transformation selon tcode
if tcode == 1
    Yg = Y; % Y_1  Y_t-h+1
elseif tcode == 2  
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
elseif tcode == 3
    Yg = (Y(h+1:end)-Y(1:end-h))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
elseif tcode == 4
    Yg = log(Y); % Y_1  Y_t-h+1
elseif tcode == 5  
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
else
    Yg = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
end



% Keep y real values for the prediction error
Y_h = Yg;




end

