function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat,eps,FMAlags,FARlags,IARlags,Fnumber,Yhat_density] = FAVARMA(Y,W,h,Pmax,Qmax,Kmax,K,R,rollwind,tcode,n_T,ncase,Density)
% Fait une analyse out-of-sample avec un FAVARMA selon 4 possibilit�s de
% repr�sentation. Peut faire plusieurs variables � la fois

% INPUT
% Y: variables � pr�voir en niveau
% ind: Indices des variables � pr�voir dans W
% tcode: codes de transformation des variables � pr�voir
% W: Ensemble de donn�es T x K, il ne doit plus y avoir de valeurs
% manquantes
% h: horizon de la pr�vision
% Qmax: COmposante moyenne mobile
% Kmax: nombre maximal de facteurs pour test de Bai et Ng (2002) (2,2) []
% si on impose K
% K: Nb de facteurs impos�s au lieu du test [] si Bai
% Pmax: nb de lag maximal pour composante idiosyncratique et facteurs
% R: Taille de la fen�tre d'estimation
% tcode: Type de pr�vision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))
% ncase : type de repr�sentation: 1:VARMA DIAG MA 2:VARMA DIAG AR 3:VARMA
% FINAL MA 4: VARMA FINAL AR
% n_t : Pour l'estimation du long VAR (10 QC et 20 US)

% OUTPUT
% MSPE: Moyenne des erreurs de pr�vision au carr�
% MAPE: Moyenne des erreurs de pr�vision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)
% Flag: Lag des facteurs
% Ilags: Lag des composantes idisyncratiques
% Fnumber: Nb de facteurs

[T,M] = size(Y);
Yr = Y;

% Transformation selon tcode
for m = 1:M
    if tcode(1,m) == 1
        Yr(:,m) = Y(:,m); % Y_1 � Y_t-h+1
        Yniv1 = Y;
      
    elseif tcode(1,m) == 2
        Yr(:,m) = [NaN(h,1);(Y(h+1:end,m)-Y(1:end-h,m))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h
        Yniv1 = Y;
       
    elseif tcode(1,m) == 3
        Y3 = (Y(h+1:end,m)-Y(1:end-h,m))/h;
        Yr(:,m) = [NaN(h+1,1);Y3(2:end,1)-(Y(1+1:end-h,m) - Y(1:end-h-1,m))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
        Yniv1 = Y;
        
    elseif tcode(1,m) == 4
        Yr(:,m) = log(Y(:,m)); % Y_1 � Y_t-h+1
        Yniv1 = log(Y(:,m));
       
    elseif tcode(1,m) == 5 
        Yr(:,m) = [NaN(h,1);(log(Y(h+1:end,m))-log(Y(1:end-h,m)))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
        Yniv1 = log(Y);
    
    else
        Y3 = (log(Y(h+1:end,m))-log(Y(1:end-h,m)))/h;
        Yr(:,m) = [NaN(h+1,1);Y3(2:end,1)-(log(Y(1+1:end-h,m)) - log(Y(1:end-h-1,m)))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
        Yniv1 = log(Y);
        
    end
end

drop = 2;
Out_s = T-R;
kd = length(Density);

% Keep y real values for the prediction error
real_y = Yr(R+1:end,:);


% Output object
Y_hat = zeros(Out_s,M);
Yhat_density = NaN(Out_s,M,kd);


% Keep information about factor
if isempty(K) == 1
    FMAlags = NaN(Out_s,Kmax);
    FARlags = NaN(Out_s,Kmax);  
else
    FMAlags = NaN(Out_s,K);
    FARlags = NaN(Out_s,K);
end

IARlags = NaN(Out_s,M);
Fnumber = NaN(Out_s,1);

% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les derni�res h obs h p�riode en avance, avec h = 1, 1:R pour pr�voir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    
    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le le nombre d'obs manquantes d�pend de l'it�ration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs � dropper ne d�pend pas de l'it�ration dans le cas d'expending
    end
    
    
    Yniv = Yniv1(dataRange,:);
    Yniv = Yniv(1+drop1:end,:);
    
    WW = W(dataRange,:);
    WW = WW(1+drop1:end,:);

    % Estimation des facteurs statiques et moyenne et �cart-type de la
    % variable � pr�voir
    
    if isempty(K) == 1
    % Test de Bai et Ng (2002)
    IC2 = nbplog(WW,Kmax,2,2);
    
        Kstar = IC2;
    else
        Kstar = K;    
    end
    
    
    [Idio_er,Fhat,Lambda,junk]=pc(zscore(WW),Kstar);
    mu = mean(WW);
    sig = std(WW);
    
    %% Pr�vision des facteurs selon la repr�sentation utilis�e
    delta = 0.5; % Pour l'estimation de l'ordre AR MA diminue la p�nalit�
    c_0 = 1.0; 
    m_T = 10;
    
    % VARMA DIAG MA
    if ncase == 1
        [opt_p,opt_q] = estim_orders_varma_diag_ma(Fhat',delta,c_0,m_T,Pmax,Qmax*ones(Kstar,1),n_T);  %v�rifier Qmax*ones
        
    % VARMA DIAG AR
    elseif ncase == 2
        [opt_p,opt_q] = estim_orders_varma_diag_ar(Fhat',delta,c_0,m_T,Pmax*ones(Kstar,1),Qmax,n_T);  %v�rifier Pmax*ones

    % FINAL VARMA MA    
    elseif ncase == 3
        [opt_p,opt_q] = estim_orders_varma_final_ma(Fhat',delta,c_0,m_T,Pmax,Qmax,n_T);

    % FINAL VARMA AR    
    else
        [opt_p,opt_q] = estim_orders_varma_final_ar(Fhat',delta,c_0,m_T,Pmax,Qmax,n_T);
        
    end    
    
    % imposer opt_p et opt_q
    
%     for z = 1:length(opt_p)
%         opt_p(z) = Pmax;
%     end
%     
%     for z = 1:length(opt_q)
%         opt_q(z) = Qmax;
%     end
    
%     opt_p = 1;
%     opt_q = ones(Kstar,1);
    
    if opt_q == 0
        opt_q =1;
    end
    
    if opt_p == 0
        opt_p = 1;
    end


    [junk,Ffor,A_hat,B_hat,u_bar,p_est,q_est] = fcst_varma_sequential(Fhat,opt_p,opt_q,h,1,delta,c_0,m_T,n_T,ncase);
    a_hat = [];
    b_hat = [];
    for pp = 1:p_est
        a_hat = [a_hat A_hat{pp}];
    end
    
   
 
    
    for qq = 1:q_est   
        b_hat = [b_hat B_hat{qq}];
    end
    p_est = max(p_est);
    q_est = max(q_est);
    
    A_hat = a_hat;
    B_hat = b_hat;
    
    A_11 = [A_hat;[eye(Kstar*(p_est-1)),zeros(Kstar*(p_est-1),Kstar)]];
    A_21 = zeros(Kstar*q_est,Kstar*p_est);
    A_22 = [zeros(Kstar,Kstar*q_est);[eye(Kstar*(q_est-1)),zeros(Kstar*(q_est-1),Kstar)]];
    A_12 = [B_hat;zeros(Kstar*p_est-size(B_hat,1),Kstar*q_est)];
    
    A = [[A_11,A_12];[A_21,A_22]];
    J = [eye(Kstar),zeros(Kstar,Kstar*(p_est+q_est)-Kstar)];
    H = [eye(Kstar);zeros(Kstar*p_est-Kstar,Kstar);eye(Kstar);zeros(Kstar*q_est-Kstar,Kstar)];
    
    sigma2 = u_bar*u_bar'/(size(u_bar,1)-(p_est+q_est+1));
        
    
    % bug here when q_est = 0... set q_est to at least 1
    for ii = 0:h-1
        THETA_i{ii+1} = J*(A^ii)*H;
    end
    
    
    MSE = 0;
    for ii = 0:h-1
        MSE = MSE+THETA_i{ii+1}*sigma2*THETA_i{ii+1}';
        MSE_all{ii+1} = MSE;
    end

    
    
    Ffor = Ffor(:,end-h+1:end)';
    
    %% Pr�vision de la composante idiosyncratique avec AR(p) it�ratif pour H = 1...h, choix
    % du nombre de lag avec BIC
    
    best_p = NaN(1,M);
    
    for m = 1:M   
    
         Idio = Idio_er(:,m);
        [idiofor, best_p,~,FEV] = ARit(Idio_er(:,m),Pmax,h);
         Ilags(tt,m) = best_p;
         Lambda1 = Lambda';
         Lambda1 = Lambda1(:,m);


        if tcode(1,m) == 1 | tcode(1,m) == 4
            

            forecast_std = sqrt(FEV+Lambda1'*MSE_all{h}*Lambda1);
            sfac=Ffor(h,:);
            sidio=idiofor(h,1);
            Y_hat(tt,m)=sig(m)*(sfac*Lambda1+sidio)+mu(m);

            for dd = 1:kd
                Yhat_density(tt,m,dd) = sig(m)*(Y_hat(tt,m)+Density(dd)*forecast_std)+mu(m);
            end

        elseif tcode(1,m) == 2 | tcode(1,m) == 5
            diff1Y = sig(m)*(Ffor*Lambda1+idiofor)+ repmat(mu(m),h,1);
            Y_hat(tt,m)=sum(diff1Y)/h;

            for dd = 1:kd
                for hh = 1:h
                    forecast_std = sqrt(FEV+Lambda1'*MSE_all{hh}*Lambda1);
                    diff1Y_dens(hh,1) = sig(m)*(diff1Y(hh)+forecast_std*Density(dd))+ mu(m);
                end

                Yhat_density(tt,m,dd) = sum(diff1Y_dens)/h;
            end



        elseif tcode(1,m) == 3 | tcode(1,m) == 6
            mu1=repmat(mu(m),h,1);

            Yd2=(sig(m)*(Ffor*Lambda1+idiofor)+mu1);

            Y_hat(tt,m) = I2toI2h(Yd2,Yniv(end-1:end,m),h);


            for dd = 1:kd
                for hh = 1:h
                    forecast_std = sqrt(FEV+Lambda1'*MSE_all{hh}*Lambda1);
                    Yd2_dens(hh,1) = sig(m)*(Yd2(hh)+forecast_std*Density(dd))+ mu(m);
                end
                Yhat_density(tt,m,dd) = I2toI2h(Yd2_dens,Yniv(end-1:end,m),h);
            end        

        end
    end
  
  FARlags(tt,1:length(opt_p)) = opt_p';
  FMAlags(tt,1:length(opt_q)) = opt_q';
  Fnumber(tt,1) = Kstar;      
  IARlags(tt,:) = best_p;
    
  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+tt;
  end

end
  

eps  = real_y-Y_hat; 

% Calcul des m�triques
MSPE = NaN(1,M);
MAPE = NaN(1,M);
THEIL = NaN(1,M);
Tbiais = NaN(1,M);
Tvar = NaN(1,M);
Tcov = NaN(1,M);
Sign = NaN(1,M);
PR2 = NaN(1,M);

for m = 1:M


% M�triques de base
MSPE(1,m) = mean(eps(:,m).^2);
MAPE(1,m) = mean(abs(eps(:,m)));

% Coefficients de Theil
THEIL(1,m)  = sqrt(MSPE(1,m))/(sqrt(mean(Y_hat(:,m).^2))+sqrt(mean(real_y(:,m).^2)));
Tbiais(1,m) = ((mean(Y_hat(:,m))-mean(real_y(:,m)))^2)/MSPE(1,m);
Tvar(1,m)   = ((std(Y_hat(:,m))-std(real_y(:,m)))^2)/MSPE(1,m);
Tcov(1,m)   = (2*(1-corr(Y_hat(:,m),real_y(:,m)))*std(Y_hat(:,m))*std(real_y(:,m)))/MSPE(:,m);


%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diff�rence)
if tcode(1,m) == 1 | tcode(1,m) == 4
    Sign(1,m) = NaN;
else
    
n = size(real_y,1);

[real_pos,junk] = find(real_y(:,m)>0);
[pred_pos,junk] = find(Y_hat(:,m)>0);
[positive,junk] = find(real_y(:,m)>0 & Y_hat(:,m)>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign(1,m) = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);

end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y(:,m),R,h,rollwind,tcode(1,m));
PR2(1,m) = 1 - MSPE(1,m)/MSPEmean;

end

end