function [Ffor,optlag,MSE] = FACTORADL(fhat,Pmax,h)

% y: Y_{1}  Y_{t} pour prvoir jusqu' Y_{t+h}
% Pmax: Nombre maximal de lag  considrer
% h: horizon de la prvision
% k: nb de facteurs optimal choisi par BIC

% Yhat: Yhat_{t+1}  Yhat_{t+h}
% best_p: nombre de lag optimal selon BIC


[T,k] = size(fhat);


 [X,Xlag] = lagML2(fhat(1:end-h,:),Pmax); 
  X = [X, Xlag(:,1:end-k)];



 possible_lag = 1:Pmax*k;
 possible_lag = reshape(possible_lag,k,Pmax)';

   
 ALL_possible_lag_combination = repmat([1:Pmax]',1,k);

 BIC = zeros(size(ALL_possible_lag_combination,1),1);
 allB = cell(size(ALL_possible_lag_combination,1),1);
 
 
 
     for pp = 1:size(ALL_possible_lag_combination,1);
     
         comb = ALL_possible_lag_combination(pp,:);
         
         b = [];
         for ii = 1:k
            a = possible_lag(1:comb(1,ii),ii);
            b = [b a'];
         end
         
         choice = sort(b);
         XX = X(:,choice);
     
     
        % Cration de la matrice de variables "indpendantes"
        allX = [ones(size(XX,1),1) XX];
        YX = [fhat(h+1:end,:),allX];
        YX = YX(~any(isnan(YX),2),:);  
        
        

        % Rgression
        beta = YX(:,k+1:end)\YX(:,1:k);
        allB{pp,1} = beta;  %crer avant pour la vitesse

         % Fit du in-sample
         par = size(beta,1);
         ttt = size(allX,1);

         yin = YX(:,k+1:end)*beta;
         res = YX(:,1:k) - yin;
         sigma2{pp} = res'*res/(ttt-par);

        % Calcul des critres d'information
        BIC(pp,1) = log(det(sigma2{pp}))+ par*k*log(ttt)/ttt;

     end                             
                                
                                
                                
    
  [junk,minBIC]  = min(BIC);
   

  % Cration des variables "indpendantes" pour la prvision
  best_comb = ALL_possible_lag_combination(minBIC,:);
  
  
 b = [];
     for ii = 1:k
        a = possible_lag(1:best_comb(1,ii),ii);
        b = [b a'];
     end
     best_choice = sort(b);
     
    [X,Xlag] = lagML2(fhat,Pmax); 
     X = [X, Xlag(:,1:end-k)];
     XX = X(end,best_choice);
     
    beta = allB{best_comb(1,1),1};
    MSE = sigma2{best_comb}; 
    
    
    XX = repmat([1 XX],k,1);
    
    Ffor = XX*beta;
    Ffor = diag(Ffor)';
    optlag=best_comb(1,1);
    
    

end

