function [Y_hat,eps] = Direct_lasso_forc(Y,W1,h,Pmax,R,KK,rollwind,tcode,Density)
% Fait une analyse out-of-sample avec un mod�le � diffusion index
% This one


% INPUT
% Y: Variable � pr�dire
% W: Ensemble de donn�es T x K (garder NaN lorsqu'on perd des obs lors de
% transformation)
% h: horizon de la pr�vision
% Pmax: nombre maximal de retard de la variable � pr�voir
% Mmax: nombre de retard des facteurs
% Kmax: nombre maximal de facteurs
% R: Taille de la fen�tre d'estimation

% tcode: Type de pr�vision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))


% Transformation selon fortype
if tcode == 1
    Yg = Y; % Y_1 � Y_t-h+1
    Yd = Y; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 2  
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(Y)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 3
    Yg = (Y(h+1:end)-Y(1:end-h))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(Y,2)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 4
    Yg = log(Y); % Y_1 � Y_t-h+1
    Yd = log(Y); % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 5  
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(log(Y))]; % Y_1 � Y_t-h+1
    drop = 2;
else
    Yg = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(log(Y),2)]; % Y_1 � Y_t-h+1
    drop = 2;
end
    
    
T = size(Y,1);
Out_s = T-R;
Kd = length(Density);

% Keep y real values for the prediction error
real_y = Yg(R+1:end);


% Output object
Y_hat = zeros(Out_s,1);
Yhat_density = NaN(Out_s,length(Density));


% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les derni�res h obs h p�riode en avance, avec h = 1, 1:R pour pr�voir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    

    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le nombre d'obs manquantes d�pend de l'it�ration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs � dropper ne d�pend pas de l'it�ration dans le cas d'expending
    end
    
    YYg = Yg(dataRange,1); % Y_1 � Y_t-h+1
    YYd = Yd(dataRange,1); % Y_1 � Y_t-h+1
    
    
   
    WW1 = W1(dataRange,:);
    WW1 = WW1(1+drop1:end,:);
    WW1 = WW1(:,~any(isnan(WW1),1));
    [WW1,ind1] = unique(WW1','rows');

    WW1 = WW1';

    keep1 = softreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW1(1:end-h,:),1,KK);
    k = length(keep1);            
    
    
    WW = WW1(:,keep1);
    [fsl1,fsllag1] = lagML2(WW(1:end-h,:),1); 
     fsl1 = [fsl1,fsllag1(:,1:end-1*k)];  % F_{t-2h+1} F_{t-2h+1-1} ...
        
    BIC = NaN(1,Pmax);
    sigma2 = NaN(Pmax,1);

            for p = 1:Pmax  

                [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
                 XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                                    %  lag 1        lag 2          lag 3              lag p

                % On perd les obs selon drop1
                XX = XX(1+drop1:end,:);



                % Cr�ation de la matrice de variables "ind�pendantes"
                XXX = [ones(size(fsl1,1),1),XX,fsl1];
                YX = [YYg(h+1+drop1:end,1),XXX];
                YX = YX(~any(isnan(YX),2),:);

                % R�gression
                beta = YX(:,2:end)\YX(:,1);
                allB{p} = beta;

                % Fit du in-sample
                par = size(XXX,2);
                ttt = size(YX,1);

                yin = YX(:,2:end)*beta;
                res = YX(:,1) - yin;
                sigma2(p,1) = res'*res/(ttt-par);

                % Calcul des crit�res d'information
                BIC(1,p) = log(sigma2(p,1))+ par*log(ttt)/ttt;

            end
               

            
            [C,I]   = min(BIC);
            P = ind2sub(size(BIC),I);
            best_p  = P;


              % Cr�ation des variables "ind�pendantes" pour la pr�vision
              % Retard de Y

              [y,ylag] = lagML2(YYd,best_p);    
              y = [y(:,1),ylag(:,1:end-1)];
              y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)


              % W
              [FF1,FFlag1] = lagML2(WW,1);
              FF1 = [FF1,FFlag1(:,1:end-1*k)];
              FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)

              % Variables pr�dictives
              lastx = [1,y,FF1];

              % on prend le bon beta
              fbeta = allB{best_p};

              % Forecast error variance
              sigma = sqrt(sigma2(best_p));
      
              
              % Pr�vision
              Y_hat(tt,1) = lastx*fbeta;
              
           

  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+tt;
  end

end
  

eps  = real_y-Y_hat; 


end

