function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat,eps,Flag,Fnumber,optilag,skeep,VAR_kept1,VAR_kept2,VAR_kept3,Yhat_density] = DIINDEX3hard(Y,W1,W2,W3,W1_ind,W2_ind,W3_ind,h,Pmax,Mmax,Kmax,R,tc,rollwind,tcode,Density)
% Fait une analyse out-of-sample avec un modle  diffusion index

% INPUT
% Y: Variable  prdire
% W: En semble de donnes T x K
% h: horizon de la prvision
% Pmax: nombre maximal de retard de la variable  prvoir
% Mmax: nombre de retard des facteurs
% Kmax: nombre maximal de facteurs
% R: Taille de la fentre d'estimation

%    Utilise le hardtreshold de Bai et Ng (2008)
% tcode: Type de prvision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))


% OUTPUT
% OUTPUT
% MSPE: Moyenne des erreurs de prvision au carr
% MAPE: Moyenne des erreurs de prvision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)
% Flag: Lag des facteurs
% Fnumber: Nb de facteurs
% optilag: nb lag de y



% Transformation selon fortype
if tcode == 1
    Yg = Y; % Y_1  Y_t-h+1
    Yd = Y; % Y_1  Y_t-h+1
    drop = 2;
elseif tcode == 2  
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(Y)]; % Y_1  Y_t-h+1
    drop = 2;
elseif tcode == 3
    Yg = (Y(h+1:end)-Y(1:end-h))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(Y,2)]; % Y_1  Y_t-h+1
    drop = 2;
elseif tcode == 4
    Yg = log(Y); % Y_1  Y_t-h+1
    Yd = log(Y); % Y_1  Y_t-h+1
    drop = 2;
elseif tcode == 5  
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(log(Y))]; % Y_1  Y_t-h+1
    drop = 2;
else
    Yg = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(log(Y),2)]; % Y_1  Y_t-h+1
    drop = 2;
end


if size(W2,1) == 0
    nbase = 1;
elseif size(W3,1) == 0
    nbase = 2;
else
    nbase = 3;
end
    
    

T = size(Y,1);
Out_s = T-R;
Kd = length(Density);

% Keep y real values for the prediction error
real_y = Yg(R+1:end);

% Output object
Y_hat = zeros(Out_s,1);
Yhat_density = NaN(Out_s,length(Density));


% Keep information about factor
Flag = zeros(Out_s,3);
Fnumber = zeros(Out_s,6);
skeep = NaN(Out_s,3);
optilag = zeros(Out_s,1);


% Keep information about variable to extract factor

    VAR_kept1 = NaN(Out_s,size(W1,2));
    VAR_kept2 = NaN(Out_s,size(W2,2));
    VAR_kept3 = NaN(Out_s,size(W3,2));






% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les dernires h obs h priode en avance, avec h = 1, 1:R pour prvoir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    
     if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le le nombre d'obs manquantes dpend de l'itration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs  dropper ne dpend pas de l'itration dans le cas d'expending
    end
    
    YYg = Yg(dataRange,1); % Y_1  Y_t-h+1
    YYd = Yd(dataRange,1); % Y_1  Y_t-h+1
    
    
    
    
    if nbase == 1
        kept_ind_1 = W1_ind;
        
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        
        kept_ind_1 = kept_ind_1(1,~any(isnan(WW1),1));
        
        WW1 = WW1(:,~any(isnan(WW1),1));
        [WW1,ind1] = unique(WW1','rows');
        
        kept_ind_1 = kept_ind_1(ind1);
        
        WW1 = WW1';
        
        allB = cell(Pmax,Kmax,Mmax);
    elseif nbase == 2
        kept_ind_1 = W1_ind;
        kept_ind_2 = W2_ind;
        
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        
        kept_ind_1 = kept_ind_1(1,~any(isnan(WW1),1));
        
        WW1 = WW1(:,~any(isnan(WW1),1));
        [WW1,ind1] = unique(WW1','rows');
        
        kept_ind_1 = kept_ind_1(ind1);
        
        WW1 = WW1';
        
        WW2 = W2(dataRange,:);
        WW2 = WW2(1+drop1:end,:);
        
        kept_ind_2 = kept_ind_2(1,~any(isnan(WW2),1));
        
        WW2 = WW2(:,~any(isnan(WW2),1));
        [WW2,ind2] = unique(WW2','rows');
        
        kept_ind_2 = kept_ind_2(ind2);
        
        WW2 = WW2';
        allB = cell(Pmax,Kmax,Kmax,Mmax,Mmax);
    else
        kept_ind_1 = W1_ind;
        kept_ind_2 = W2_ind;
        kept_ind_3 = W3_ind;
        
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        
        kept_ind_1 = kept_ind_1(1,~any(isnan(WW1),1));
        
        WW1 = WW1(:,~any(isnan(WW1),1));
        [WW1,ind1] = unique(WW1','rows');
        
        kept_ind_1 = kept_ind_1(ind1);
        
        WW1 = WW1';
        
        WW2 = W2(dataRange,:);
        WW2 = WW2(1+drop1:end,:);
        
        kept_ind_2 = kept_ind_2(1,~any(isnan(WW2),1));
        
        WW2 = WW2(:,~any(isnan(WW2),1));
        [WW2,ind2] = unique(WW2','rows');
        
        kept_ind_2 = kept_ind_2(ind2);
        
        WW2 = WW2';
        
        WW3 = W3(dataRange,:);
        WW3 = WW3(1+drop1:end,:);
        
        kept_ind_3 = kept_ind_3(1,~any(isnan(WW3),1));
        
        WW3 = WW3(:,~any(isnan(WW3),1));
        [WW3,ind3] = unique(WW3','rows');
        
        kept_ind_3 = kept_ind_3(ind3);
        
        WW3 = WW3';
        allB = cell(Pmax,Kmax,Kmax,Kmax,Mmax,Mmax,Mmax);
    end
 
    
    

      
        
    %% Cas avec un seul ensemble de donnes pour facteurs 
    if nbase == 1 
        BIC = zeros(Kmax,Mmax,Pmax);  
        FYN = NaN(2,Kmax,Mmax,Pmax);
        sigma2 = NaN(Kmax,Mmax,Pmax);
        
        keep1 = hardtreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW1(1:end-h,:),tc,1);
        VAR_kept1(tt,1:length(keep1)) = kept_ind_1(keep1);
        keep2 = [];
        keep3 = [];
      
        for k1 = 1:Kmax
            
            if size(keep1,2)==0
               fs1 = [];
            elseif size(keep1,2)<k1
               f1 = WW1(:,keep1);
               fs1 = f1(1:end-h,:);
            else
               [ehat1,f1,lambda1,ss1]=pc(zscore(WW1(:,keep1)),k1); %k1 par Kmax   la fin k1 inclu jusqwu' Kmax, donc ils sont tous accessible
               fs1 = f1(1:end-h,:);  % fs1 = f1(:,1:k1); 
            end


            for p = 1:Pmax  

            [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
             XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                                    %  lag 1        lag 2          lag 3              lag p
             XX = XX(1+drop1:end,:);
              
                for m1 = 1:Mmax
                
                    if size(keep1,2) > 0 
                        [fsl1,fsllag1] = lagML2(fs1,m1); 
                        fsl1 = [fsl1,fsllag1(:,1:end-1*size(fs1,2))];  % F_{t-2h+1} F_{t-2h+1-1} ...
                    else
                        fsl1 = [];
                    end
                    
                    % Cration de la matrice de variables "indpendantes"
                    XXX = [ones(size(XX,1),1),XX,fsl1];
                    YX = [YYg(h+1+drop1:end,1),XXX];
                    YX = YX(~any(isnan(YX),2),:);

                    % Rgression
                    beta = YX(:,2:end)\YX(:,1);
                    allB{p,k1,m1} = beta;

                    % Fit du in-sample
                    par = size(XXX,2);
                    ttt = size(YX,1);

                    yin = YX(:,2:end)*beta;
                    res = YX(:,1) - yin;
                    sigma2(k1,m1,p) = res'*res/(ttt-par);

                    % Calcul des critres d'information
                    BIC(k1,m1,p) = log(sigma2(k1,m1,p))+ par*log(ttt)/ttt;
                    if size(keep1,2)<k1
                        FYN(1,k1,m1,p) = 0;
                        FYN(2,k1,m1,p) = size(keep1,2);
                    else
                        FYN(1,k1,m1,p) = k1;
                        FYN(2,k1,m1,p) = k1;
                    end
                end
            end
        end

        minimum = min(min(min(BIC)));

        [K1,M1,P] = ind2sub(size(BIC),find(BIC==minimum));
        best_k1  = K1(1);
        best_m1  = M1(1);
        best_p  = P(1);
        
        if size(keep1,2) == 0
           f1 = [];
        elseif size(keep1,2)<best_k1
           f1 = WW1(:,keep1);
        else
           [ehat1,f1,lambda1,ss1]=pc(zscore(WW1(:,keep1)),best_k1);   
        end

      % Cration des variables "indpendantes" pour la prvision
      % Retard de Y

      [y,ylag] = lagML2(YYd,best_p);    
      y = [y(:,1),ylag(:,1:end-1)];
      y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)


      % Retard de F
      
      if size(keep1,2) == 0
          FF1 = [];
      else
          [FF1,FFlag1] = lagML2(f1,best_m1);
          FF1 = [FF1,FFlag1(:,1:end-1*size(FF1,2))];
          FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      end

      % Variables prdictives
      lastx = [1,y,FF1];

      % on prend le bon beta
      fbeta = allB{best_p,best_k1,best_m1};

      % Prvision
      Y_hat(tt,1) = lastx*fbeta;
      
      sigma = sqrt(sigma2(best_k1,best_m1,best_p));
      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end

      
      
      
      
      Flag(tt,1) = best_m1;
      Fnumber(tt,1:nbase*2) = FYN(:,best_k1,best_m1,best_p)';
      skeep(tt,1) = size(keep1,2);
      skeep(tt,2) = size(keep2,2);
      skeep(tt,3) = size(keep3,2);
      


    %%           Cas avec deux ensembles de donnes pour facteurs  

    elseif nbase == 2 
         FYN = NaN(4,Kmax,Kmax,Mmax,Mmax,Pmax);
         BIC = zeros(Kmax,Kmax,Mmax,Mmax,Pmax);
         sigma2 = NaN(Kmax,Kmax,Mmax,Mmax,Pmax);

         
        keep1 = hardtreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW1(1:end-h,:),tc,1);
        keep2 = hardtreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW2(1:end-h,:),tc,1);
        keep3 = [];
        VAR_kept1(tt,1:length(keep1)) = kept_ind_1(keep1);
        VAR_kept2(tt,1:length(keep2)) = kept_ind_2(keep2);
        
        for k1 = 1:Kmax    
            
            if size(keep1,2) == 0 
                fs1 = [];
            
            elseif size(keep1,2)<k1
               f1 = WW1(:,keep1);
               fs1 = f1(1:end-h,:);
            else
               [ehat1,f1,lambda1,ss1]=pc(zscore(WW1(:,keep1)),k1);   
               fs1 = f1(1:end-h,:);
            end


            for k2 = 1:Kmax    
                if size(keep2,2) == 0
                    fs2 = [];
                elseif size(keep2,2)<k2
                   f2 = WW2(:,keep2);
                   fs2 = f2(1:end-h,:);
                else
                   [ehat2,f2,lambda2,ss2]=pc(zscore(WW2(:,keep2)),k2);   
                   fs2 = f2(1:end-h,:);
                end


                for p = 1:Pmax  

                [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
                 XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                                    %  lag 1        lag 2          lag 3              lag p

                 XX = XX(1+drop1:end,:);
                 
                 
                    for m1 = 1:Mmax
                        for m2 = 1:Mmax
                            
                            
                            % 1er groupe
                            if size(keep1,2) > 0 
                                [fsl1,fsllag1] = lagML2(fs1,m1); 
                                fsl1 = [fsl1,fsllag1(:,1:end-1*size(fs1,2))];  % F_{t-2h+1} F_{t-2h+1-1} ...
                            else
                                fsl1 = [];
                            end
                            
                            % 2me groupe
                            if size(keep2,2) > 0 
                                [fsl2,fsllag2] = lagML2(fs2,m2); 
                                fsl2 = [fsl2,fsllag2(:,1:end-1*size(fs2,2))];  % F_{t-2h+1} F_{t-2h+1-1} ...
                            else
                                fsl2 = [];
                            end
                            
                            
                            

                            % Cration de la matrice de variables "indpendantes"
                            XXX = [ones(size(XX,1),1),XX,fsl1,fsl2];
                            YX = [YYg(h+1+drop1:end,1),XXX];
                            YX = YX(~any(isnan(YX),2),:);

                            % Rgression
                            beta = YX(:,2:end)\YX(:,1);
                            allB{p,k1,k2,m1,m2} = beta;

                            % Fit du in-sample
                            par = size(XXX,2);
                            ttt = size(YX,1);

                            yin = YX(:,2:end)*beta;
                            res = YX(:,1) - yin;
                            sigma2(k1,k2,m1,m2,p) = res'*res/(ttt-par);

                            % Calcul des critres d'information
                            BIC(k1,k2,m1,m2,p) = log(sigma2(k1,k2,m1,m2,p))+ par*log(ttt)/ttt;

                            if size(keep1,2)<k1
                               FYN(1,k1,k2,m1,m2,p) = 0;
                               FYN(2,k1,k2,m1,m2,p) = size(keep1,2);
                            else
                               FYN(1,k1,k2,m1,m2,p) = k1;
                               FYN(2,k1,k2,m1,m2,p) = k1;
                            end

                            if size(keep2,2)<k2
                               FYN(3,k1,k2,m1,m2,p) = 0;
                               FYN(4,k1,k2,m1,m2,p) = size(keep2,2);
                            else
                               FYN(3,k1,k2,m1,m2,p) = k2;
                               FYN(4,k1,k2,m1,m2,p) = k2;
                            end
                        end
                    end
                end
            end
        end

        minimum  = min(min(min(min(min(BIC)))));
        [K1,K2,M1,M2,P] = ind2sub(size(BIC),find(BIC==minimum));
        best_k1  = K1(1);
        best_k2 = K2(1);
        best_m1  = M1(1);
        best_m2 = M2(1);
        best_p  = P(1);

        
        if size(keep1,2) == 0
           f1 = [];
        elseif size(keep1,2)<best_k1
           f1 = WW1(:,keep1);
        else
           [ehat1,f1,lambda1,ss1]=pc(zscore(WW1(:,keep1)),best_k1);   
        end
        
        
        if size(keep2,2) == 0 
           f2 = [];
        elseif size(keep2,2)<best_k2
           f2 = WW2(:,keep2);
        else
           [ehat2,f2,lambda2,ss2]=pc(zscore(WW2(:,keep2)),best_k2);   
        end
        

      % Cration des variables "indpendantes" pour la prvision
      % Retard de Y

      [y,ylag] = lagML2(YYd,best_p);    
      y = [y(:,1),ylag(:,1:end-1)];
      y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)


      % Retard de F1
      if size(keep1,2) == 0
          FF1 = [];
      else
          [FF1,FFlag1] = lagML2(f1,best_m1);
          FF1 = [FF1,FFlag1(:,1:end-1*size(FF1,2))];
          FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      end

      % Retard de F2
      if size(keep2,2) == 0
          FF2 = [];
      else
         [FF2,FFlag2] = lagML2(f2,best_m2);
          FF2 = [FF2,FFlag2(:,1:end-1*size(FF2,2))];
          FF2 = FF2(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      end

      % Variables prdictives
      lastx = [1,y,FF1,FF2];

      % on prend le bon beta
      fbeta = allB{best_p,best_k1,best_k2,best_m1,best_m2};

      % Prvision
      Y_hat(tt,1) = lastx*fbeta;
      
      sigma = sqrt(sigma2(best_k1,best_k2,best_m1,best_m2,best_p));
      
      
      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end

      Flag(tt,1) = best_m1;
      Flag(tt,2) = best_m2;
      Fnumber(tt,1:nbase*2) = FYN(:,best_k1,best_k2,best_m1,best_m1,best_p)';
      skeep(tt,1) = size(keep1,2);
      skeep(tt,2) = size(keep2,2);
      skeep(tt,3) = size(keep3,2);



    %% Cas avec 3 ensembles de donnes pour facteurs  

    else    

    BIC = zeros(Kmax,Kmax,Kmax,Mmax,Mmax,Mmax,Pmax);  
    FYN = NaN(6,Kmax,Kmax,Kmax,Mmax,Mmax,Mmax,Pmax); 
    sigma2 = NaN(Kmax,Kmax,Kmax,Mmax,Mmax,Mmax,Pmax);
    
    keep1 = hardtreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW1(1:end-h,:),tc,1);
    keep2 = hardtreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW2(1:end-h,:),tc,1);
    keep3 = hardtreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW3(1:end-h,:),tc,1);    
    VAR_kept1(tt,1:length(keep1)) = kept_ind_1(keep1);
    VAR_kept2(tt,1:length(keep2)) = kept_ind_2(keep2);
    VAR_kept3(tt,1:length(keep3)) = kept_ind_3(keep3);
    
    for k1 = 1:Kmax

        if size(keep1,2) == 0
            fs1 = [];
        elseif size(keep1,2)<k1
           f1 = WW1(:,keep1);
           fs1 = f1(1:end-h,:);
        else
           [ehat1,f1,lambda1,ss1]=pc(zscore(WW1(:,keep1)),k1);   
           fs1 = f1(1:end-h,:);
        end


        for k2 = 1:Kmax 
            if size(keep2,2) == 0 
                fs2 = [];
            elseif size(keep2,2)<k2
               f2 = WW2(:,keep2);
               fs2 = f2(1:end-h,:);
            else
               [ehat2,f2,lambda2,ss2]=pc(zscore(WW2(:,keep2)),k2);   
               fs2 = f2(1:end-h,:);
            end


            for k3 = 1:Kmax    
                if size(keep3,2) == 0
                    fs3 = [];
                elseif size(keep3,2)<k3
                   f3 = WW3(:,keep3);
                   fs3 = f3(1:end-h,:);
                else
                   [ehat3,f3,lambda3,ss3]=pc(zscore(WW3(:,keep3)),k3);   
                   fs3 = f3(1:end-h,:);
                end


                for p = 1:Pmax  
                    [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
                    XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                                        %  lag 1        lag 2          lag 3              lag p
                    % On perd les obs selon drop1
                    XX = XX(1+drop1:end,:);                                    

                    for m1 = 1:Mmax
                        for m2 = 1:Mmax
                            for m3 = 1:Mmax
                                
                                % 1er groupe
                                if size(keep1,2) > 0 
                                    [fsl1,fsllag1] = lagML2(fs1,m1); 
                                    fsl1 = [fsl1,fsllag1(:,1:end-1*size(fs1,2))];  % F_{t-2h+1} F_{t-2h+1-1} ...
                                else
                                    fsl1 = [];
                                end
                            
                                % 2me groupe
                                if size(keep2,2) > 0 
                                    [fsl2,fsllag2] = lagML2(fs2,m2); 
                                    fsl2 = [fsl2,fsllag2(:,1:end-1*size(fs2,2))];  % F_{t-2h+1} F_{t-2h+1-1} ...
                                else
                                    fsl2 = [];
                                end
                            
                                % 3me groupe
                                if size(keep3,2) > 0 
                                    [fsl3,fsllag3] = lagML2(fs3,m3); 
                                    fsl3 = [fsl3,fsllag3(:,1:end-1*size(fs3,2))];  % F_{t-2h+1} F_{t-2h+1-1} ...
                                else
                                    fsl3 = [];
                                end

                                
                                
                                
                                % Cration de la matrice de variables "indpendantes"
                                XXX = [ones(size(XX,1),1),XX,fsl1,fsl2,fsl3];
                                YX = [YYg(h+1+drop1:end,1),XXX];
                                YX = YX(~any(isnan(YX),2),:);

                                % Rgression
                                
                                beta = YX(:,2:end)\YX(:,1);
                                allB{p,k1,k2,k3,m1,m2,m3} = beta;

                                % Fit du in-samplef
                                par = size(XXX,2);
                                ttt = size(YX,1);

                                yin = YX(:,2:end)*beta;
                                res = YX(:,1) - yin;
                                sigma2(k1,k2,k3,m1,m2,m3,p) = res'*res/(ttt-par);

                                % Calcul des critres d'information
                                BIC(k1,k2,k3,m1,m2,m3,p) = log(sigma2(k1,k2,k3,m1,m2,m3,p))+ par*log(ttt)/ttt;



                                if size(keep1,2)<k1
                                   FYN(1,k1,k2,k3,m1,m2,m3,p) = 0;
                                   FYN(2,k1,k2,k3,m1,m2,m3,p) = size(keep1,2);
                                else
                                   FYN(1,k1,k2,k3,m1,m2,m3,p) = k1;
                                   FYN(2,k1,k2,k3,m1,m2,m3,p) = k1;
                                end

                                if size(keep2,2)<k2
                                   FYN(3,k1,k2,k3,m1,m2,m3,p) = 0;
                                   FYN(4,k1,k2,k3,m1,m2,m3,p) = size(keep2,2);
                                else
                                   FYN(3,k1,k2,k3,m1,m2,m3,p) = k2;
                                   FYN(4,k1,k2,k3,m1,m2,m3,p) = k2;
                                end

                                if size(keep3,2)<k3
                                   FYN(5,k1,k2,k3,m1,m2,m3,p) = 0;
                                   FYN(6,k1,k2,k3,m1,m2,m3,p) = size(keep3,2);
                                else
                                   FYN(5,k1,k2,k3,m1,m2,m3,p) = k3;
                                   FYN(6,k1,k2,k3,m1,m2,m3,p) = k3;
                                end



                            end
                        end
                    end
                end
            end
        end
     end



        minimum  = min(min(min(min(min(min(min(BIC)))))));
        [K1,K2,K3,M1,M2,M3,P] = ind2sub(size(BIC),find(BIC==minimum));
        best_k1 = K1(1);
        best_k2 = K2(1);
        best_k3 = K3(1);
        best_m1 = M1(1);
        best_m2 = M2(1);
        best_m3 = M3(1);
        best_p  = P(1);
        
        
        if size(keep1,2) == 0
           f1 = [];
        elseif size(keep1,2)<best_k1
           f1 = WW1(:,keep1);
        else
           [ehat1,f1,lambda1,ss1]=pc(zscore(WW1(:,keep1)),best_k1);   
        end
        
        
        if size(keep2,2) == 0 
           f2 = [];
        elseif size(keep2,2)<best_k2
           f2 = WW2(:,keep2);
        else
           [ehat2,f2,lambda2,ss2]=pc(zscore(WW2(:,keep2)),best_k2);   
        end
        
        if size(keep3,2) == 0
           f3 = [];
        elseif size(keep3,2)<best_k3
           f3 = WW3(:,keep3);
        else
           [ehat3,f3,lambda3,ss3]=pc(zscore(WW3(:,keep3)),best_k3);   
        end


          % Cration des variables "indpendantes" pour la prvision
          % Retard de Y

          [y,ylag] = lagML2(YYd,best_p);    
          y = [y(:,1),ylag(:,1:end-1)];
          y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)


          % Retard de F1
          if size(keep1,2) == 0
              FF1 = [];
          else
              [FF1,FFlag1] = lagML2(f1,best_m1);
              FF1 = [FF1,FFlag1(:,1:end-1*size(FF1,2))];
              FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
          end

          % Retard de F2
          if size(keep2,2) == 0
              FF2 = [];
          else
             [FF2,FFlag2] = lagML2(f2,best_m2);
              FF2 = [FF2,FFlag2(:,1:end-1*size(FF2,2))];
              FF2 = FF2(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
          end

           % Retard de F3
           if size(keep3,2) == 0
              FF3 = [];
           else
             [FF3,FFlag3] = lagML2(f3,best_m3);
              FF3 = [FF3,FFlag3(:,1:end-1*size(FF3,2))];
              FF3 = FF3(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
           end
           
          % Variables prdictives
          lastx = [1,y,FF1,FF2,FF3];

          % on prend le bon beta
          fbeta = allB{best_p,best_k1,best_k2,best_k3,best_m1,best_m2,best_m3};

          % Prvision
          Y_hat(tt,1) = lastx*fbeta;
          
          sigma = sqrt(sigma2(best_k1,best_k2,best_k3,best_m1,best_m2,best_m3,best_p));

      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end

          
          Flag(tt,1) = best_m1;
          Flag(tt,2) = best_m2;
          Flag(tt,3) = best_m3;
          Fnumber(tt,1:nbase*2) = FYN(:,best_k1,best_k2,best_k3,best_m1,best_m1,best_m3,best_p)';
          skeep(tt,1) = size(keep1,2);
          skeep(tt,2) = size(keep2,2);
          skeep(tt,3) = size(keep3,2);
    end
    
  optilag(tt,1) = best_p;  
    
  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+tt;
  end                                            
end
  eps  = real_y-Y_hat; 

% Calcul des mtriques

% Mtriques de base
MSPE = mean(eps.^2);
MAPE = mean(abs(eps));

% Coefficients de Theil
THEIL  = sqrt(MSPE)/(sqrt(mean(Y_hat.^2))+sqrt(mean(real_y.^2)));
Tbiais = ((mean(Y_hat)-mean(real_y))^2)/MSPE;
Tvar   = ((std(Y_hat)-std(real_y))^2)/MSPE;
Tcov   = (2*(1-corr(Y_hat,real_y))*std(Y_hat)*std(real_y))/MSPE;


%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diffrence)
if tcode == 1 | tcode == 4
    Sign = NaN;
else
    
n = size(real_y,1);

[real_pos,junk] = find(real_y>0);
[pred_pos,junk] = find(Y_hat>0);
[positive,junk] = find(real_y>0 & Y_hat>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);
end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y,R,h,rollwind,tcode);
PR2 = 1 - MSPE/MSPEmean;


end
