function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat,eps,Flag,Fnumber,optilag,Yhat_density] = DIINDEX3_DY(Y,W1,W2,W3,h,Pmax,Mmax,Kmax,R,rollwind,tcode,Density)
% Fait une analyse out-of-sample avec un mod�le � diffusion index, mais
% avec facteurs dynamiques

% INPUT
% Y: Variable � pr�dire
% W: Ensemble de donn�es T x K (garder NaN lorsqu'on perd des obs lors de
% transformation)
% h: horizon de la pr�vision
% Pmax: nombre maximal de retard de la variable � pr�voir
% Mmax: nombre de retard des facteurs
% Kmax: nombre maximal de facteurs
% R: Taille de la fen�tre d'estimation
% tcode: Type de pr�vision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))




% OUTPUT
% MSPE: Moyenne des erreurs de pr�vision au carr�
% MAPE: Moyenne des erreurs de pr�vision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)
% Flag: Lag des facteurs
% Fnumber: Nb de facteurs
% optilag: nb lag de y





% Transformation selon tcode
if tcode == 1
    Yg = Y; % Y_1 � Y_t-h+1
    Yd = Y; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 2  
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(Y)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 3
    Yg = (Y(h+1:end)-Y(1:end-h))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(Y,2)]; % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 4
    Yg = log(Y); % Y_1 � Y_t-h+1
    Yd = log(Y); % Y_1 � Y_t-h+1
    drop = 2;
elseif tcode == 5  
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(log(Y))]; % Y_1 � Y_t-h+1
    drop = 2;
else
    Yg = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(log(Y),2)]; % Y_1 � Y_t-h+1
    drop = 2;
end




if size(W2,1) == 0
    nbase = 1;
elseif size(W3,1) == 0
    nbase = 2;
else
    nbase = 3;
end
    
    
T = size(Y,1);
Out_s = T-R;
Kd = length(Density);


% Keep y real values for the prediction error
real_y = Yg(R+1:end);


% Output object
Y_hat = zeros(Out_s,1);
Yhat_density = NaN(Out_s,length(Density));


% Keep information about factor
Flag = zeros(Out_s,3);
Fnumber = zeros(Out_s,3);

optilag = zeros(Out_s,1);


% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les derni�res h obs h p�riode en avance, avec h = 1, 1:R pour pr�voir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    
    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le le nombre d'obs manquantes d�pend de l'it�ration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs � dropper ne d�pend pas de l'it�ration dans le cas d'expending
    end
    
    YYg = Yg(dataRange,1); % Y_1 � Y_t-h+1
    YYd = Yd(dataRange,1); % Y_1 � Y_t-h+1
    
    
    
    if nbase == 1
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        WW1 = WW1(:,~any(isnan(WW1),1));
        WW1 = unique(WW1','rows');
        WW1 = WW1';
        
        allB = cell(Pmax,Kmax,Mmax);
    elseif nbase == 2
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        WW1 = WW1(:,~any(isnan(WW1),1));
        WW1 = unique(WW1','rows');
        WW1 = WW1';
        
        WW2 = W2(dataRange,:);
        WW2 = WW2(1+drop1:end,:);
        WW2 = WW2(:,~any(isnan(WW2),1));
        WW2 = unique(WW2','rows');
        WW2 = WW2';
        allB = cell(Pmax,Kmax,Kmax,Mmax,Mmax);
    else
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        WW1 = WW1(:,~any(isnan(WW1),1));
        WW1 = unique(WW1','rows');
        WW1 = WW1';
        
        WW2 = W2(dataRange,:);
        WW2 = WW2(1+drop1:end,:);
        WW2 = WW2(:,~any(isnan(WW2),1));
        WW2 = unique(WW2','rows');
        WW2 = WW2';
        
        WW3 = W3(dataRange,:);
        WW3 = WW3(1+drop1:end,:);
        WW3 = WW3(:,~any(isnan(WW3),1));
        WW3 = unique(WW3','rows');
        WW3 = WW3';
        allB = cell(Pmax,Kmax,Kmax,Kmax,Mmax,Mmax,Mmax);
    end
    
 
    
    % Comment calculer les facteurs   (�ventuellement changer pour switch)
  
    if nbase == 1
        [f1,junk,junk]=fhlrfac(zscore(WW1),2,Kmax,20);
    elseif nbase == 2
        [f1,junk,junk]=fhlrfac(zscore(WW1),2,Kmax,20);
        [f2,junk,junk]=fhlrfac(zscore(WW2),2,Kmax,20);
    else
        [f1,junk,junk]=fhlrfac(zscore(WW1),2,Kmax,20);
        [f2,junk,junk]=fhlrfac(zscore(WW2),2,Kmax,20);
        [f3,junk,junk]=fhlrfac(zscore(WW3),2,Kmax,20);
    end
        
    
    
if nbase == 1  % Cas avec un seul ensemble de donn�es pour facteurs 
    BIC = zeros(Kmax,Mmax,Pmax);  
    sigma2 = NaN(Kmax,Mmax,Pmax);
    for p = 1:Pmax  
       
        [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
         XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                            %  lag 1        lag 2          lag 3              lag p

        % On perd les obs selon drop1
        XX = XX(1+drop1:end,:);
             
        
        for k1 = 1:Kmax
            fs1 = f1(:,1:k1);
            for m1 = 1:Mmax
                [fsl1,fsllag1] = lagML2(fs1(1:end-h,:),m1); 
                fsl1 = [fsl1,fsllag1(:,1:end-1*k1)];  % F_{t-2h+1} F_{t-2h+1-1} ...
                
                % Cr�ation de la matrice de variables "ind�pendantes"
                XXX = [ones(size(fsl1,1),1),XX,fsl1];
                YX = [YYg(h+1+drop1:end,1),XXX];
                YX = YX(~any(isnan(YX),2),:);
                
                % R�gression
                beta = YX(:,2:end)\YX(:,1);
                allB{p,k1,m1} = beta;
                
                % Fit du in-sample
                par = size(XXX,2);
                ttt = size(YX,1);
            
                yin = YX(:,2:end)*beta;
                res = YX(:,1) - yin;
                sigma2(k1,m1,p) = res'*res/(ttt-par);
                
                % Calcul des crit�res d'information
                BIC(k1,m1,p) = log(sigma2(k1,m1,p))+ par*log(ttt)/ttt;
            
            end
        end
    end
    
    minimum = min(min(min(BIC)));
    
    
    [K1,M1,P] = ind2sub(size(BIC),find(BIC==minimum));
    best_k1  = K1;
    best_m1  = M1;
    best_p  = P;
            
           
      % Cr�ation des variables "ind�pendantes" pour la pr�vision
      % Retard de Y
      
      [y,ylag] = lagML2(YYd,best_p);    
      y = [y(:,1),ylag(:,1:end-1)];
      y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)
      
      
      % Retard de F
      [FF1,FFlag1] = lagML2(f1(:,1:best_k1),best_m1);
      FF1 = [FF1,FFlag1(:,1:end-1*best_k1)];
      FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      % Variables pr�dictives
      lastx = [1,y,FF1];
      
      % on prend le bon beta
      fbeta = allB{best_p,best_k1,best_m1};
      
      % Pr�vision
      Y_hat(tt,1) = lastx*fbeta;
      
      sigma = sqrt(sigma2(best_k1,best_m1,best_p));
      
      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end

      
      Flag(tt,1) = best_m1;
      Fnumber(tt,1) = best_k1;
      
      
elseif nbase == 2 % Cas avec deux ensembles de donn�es pour facteurs  
    
    
BIC = zeros(Kmax,Kmax,Mmax,Mmax,Pmax);  
sigma2 = NaN(Kmax,Kmax,Mmax,Mmax,Pmax);

    for p = 1:Pmax  
       
        [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
         XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                            %  lag 1        lag 2          lag 3              lag p
        
        % On perd les obs selon drop1
        XX = XX(1+drop1:end,:);                                    
                                            
        for k1 = 1:Kmax
            fs1 = f1(:,1:k1);
            for k2 = 1:Kmax
                fs2 = f2(:,1:k2);
                for m1 = 1:Mmax
                    for m2 = 1:Mmax
                        % 1er groupe
                        [fsl1,fsllag1] = lagML2(fs1(1:end-h,:),m1); 
                        fsl1 = [fsl1,fsllag1(:,1:end-1*k1)];  % F_{t-2h+1} F_{t-2h+1-1} ...
                        % 2�me groupe
                        [fsl2,fsllag2] = lagML2(fs2(1:end-h,:),m2); 
                        fsl2 = [fsl2,fsllag2(:,1:end-1*k2)];  % F_{t-2h+1} F_{t-2h+1-1} ...

                        
                        % Cr�ation de la matrice de variables "ind�pendantes"
                        XXX = [ones(size(fsl1,1),1),XX,fsl1,fsl2];
                        YX = [YYg(h+1+drop1:end,1),XXX];
                        YX = YX(~any(isnan(YX),2),:);

                        % R�gression
                        beta = YX(:,2:end)\YX(:,1);
                        allB{p,k1,k2,m1,m2} = beta;

                        % Fit du in-sample
                        par = size(XXX,2);
                        ttt = size(YX,1);

                        yin = YX(:,2:end)*beta;
                        res = YX(:,1) - yin;
                        sigma2(k1,k2,m1,m2,p) = res'*res/(ttt-par);

                        % Calcul des crit�res d'information
                        BIC(k1,k2,m1,m2,p) = log(sigma2(k1,k2,m1,m2,p))+ par*log(ttt)/ttt;
                    end
                end
            end
        end
    end
    
    minimum  = min(min(min(min(min(BIC)))));
    [K1,K2,M1,M2,P] = ind2sub(size(BIC),find(BIC==minimum));
    best_k1  = K1;
    best_k2 = K2;
    best_m1  = M1;
    best_m2 = M2;
    best_p  = P;
            
           
      % Cr�ation des variables "ind�pendantes" pour la pr�vision
      % Retard de Y
      
      [y,ylag] = lagML2(YYd,best_p);    
      y = [y(:,1),ylag(:,1:end-1)];
      y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)
      
      
      % Retard de F1
      [FF1,FFlag1] = lagML2(f1(:,1:best_k1),best_m1);
      FF1 = [FF1,FFlag1(:,1:end-1*best_k1)];
      FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      % Retard de F2
     [FF2,FFlag2] = lagML2(f2(:,1:best_k2),best_m2);
      FF2 = [FF2,FFlag2(:,1:end-1*best_k2)];
      FF2 = FF2(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      % Variables pr�dictives
      lastx = [1,y,FF1,FF2];
      
      % on prend le bon beta
      fbeta = allB{best_p,best_k1,best_k2,best_m1,best_m2};
      
      % Pr�vision
      Y_hat(tt,1) = lastx*fbeta;
      
      sigma = sqrt(sigma2(best_k1,best_k2,best_m1,best_m2,best_p));
      
      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end
      
      
      Flag(tt,1) = best_m1;
      Flag(tt,2) = best_m2;
      Fnumber(tt,1) = best_k1;  
      Fnumber(tt,2) = best_k2; 
    
    
else % Cas avec 3 ensembles de donn�es pour facteurs      
    
        
BIC = zeros(Kmax,Kmax,Kmax,Mmax,Mmax,Mmax,Pmax);  
sigma2 = NaN(Kmax,Kmax,Kmax,Mmax,Mmax,Mmax,Pmax);    
    for p = 1:Pmax  
       
        [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
         XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                            %  lag 1        lag 2          lag 3              lag p
        
        % On perd les obs selon drop1
        XX = XX(1+drop1:end,:);                                    
                                            
        for k1 = 1:Kmax
            fs1 = f1(:,1:k1);
            for k2 = 1:Kmax
                fs2 = f2(:,1:k2);
                for k3 = 1:Kmax
                    fs3 = f3(:,1:k3);
                    for m1 = 1:Mmax
                        for m2 = 1:Mmax
                            for m3 = 1:Mmax
                                % 1er groupe
                                [fsl1,fsllag1] = lagML2(fs1(1:end-h,:),m1); 
                                fsl1 = [fsl1,fsllag1(:,1:end-1*k1)];  % F_{t-2h+1} F_{t-2h+1-1} ...
                                % 2�me groupe
                                [fsl2,fsllag2] = lagML2(fs2(1:end-h,:),m2); 
                                fsl2 = [fsl2,fsllag2(:,1:end-1*k2)];  % F_{t-2h+1} F_{t-2h+1-1} ...
                                % 3�me groupe
                                [fsl3,fsllag3] = lagML2(fs3(1:end-h,:),m3); 
                                fsl3 = [fsl3,fsllag3(:,1:end-1*k3)];  % F_{t-2h+1} F_{t-2h+1-1} ...

                                % Cr�ation de la matrice de variables "ind�pendantes"
                                XXX = [ones(size(fsl1,1),1),XX,fsl1,fsl2,fsl3];
                                YX = [YYg(h+1+drop1:end,1),XXX];
                                YX = YX(~any(isnan(YX),2),:);

                                % R�gression
                                beta = YX(:,2:end)\YX(:,1);
                                allB{p,k1,k2,k3,m1,m2,m3} = beta;

                                % Fit du in-sample
                                par = size(XXX,2);
                                ttt = size(YX,1);

                                yin = YX(:,2:end)*beta;
                                res = YX(:,1) - yin;
                                sigma2(k1,k2,k3,m1,m2,m3,p) = res'*res/(ttt-par);

                                % Calcul des crit�res d'information
                                BIC(k1,k2,k3,m1,m2,m3,p) = log(sigma2(k1,k2,k3,m1,m2,m3,p))+ par*log(ttt)/ttt;
                            end
                        end
                    end
                end
            end
        end
    end
    
        
    
    minimum  = min(min(min(min(min(min(min(BIC)))))));
    [K1,K2,K3,M1,M2,M3,P] = ind2sub(size(BIC),find(BIC==minimum));
    best_k1 = K1;
    best_k2 = K2;
    best_k3 = K3;
    best_m1 = M1;
    best_m2 = M2;
    best_m3 = M3;
    best_p  = P;
            
           
      % Cr�ation des variables "ind�pendantes" pour la pr�vision
      % Retard de Y
      
      [y,ylag] = lagML2(YYd,best_p);    
      y = [y(:,1),ylag(:,1:end-1)];
      y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)
      
      
      % Retard de F1
      [FF1,FFlag1] = lagML2(f1(:,1:best_k1),best_m1);
      FF1 = [FF1,FFlag1(:,1:end-1*best_k1)];
      FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      % Retard de F2
     [FF2,FFlag2] = lagML2(f2(:,1:best_k2),best_m2);
      FF2 = [FF2,FFlag2(:,1:end-1*best_k2)];
      FF2 = FF2(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
       % Retard de F2
     [FF3,FFlag3] = lagML2(f3(:,1:best_k3),best_m3);
      FF3 = [FF3,FFlag3(:,1:end-1*best_k3)];
      FF3 = FF3(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      
      % Variables pr�dictives
      lastx = [1,y,FF1,FF2,FF3];
      
      % on prend le bon beta
      fbeta = allB{best_p,best_k1,best_k2,best_k3,best_m1,best_m2,best_m3};
      
      % Pr�vision
      Y_hat(tt,1) = lastx*fbeta;
      
      sigma = sqrt(sigma2(best_k1,best_k2,best_k3,best_m1,best_m2,best_m3,best_p));
      
      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end
      
      Flag(tt,1) = best_m1;
      Flag(tt,2) = best_m2;
      Flag(tt,3) = best_m3;
      Fnumber(tt,1) = best_k1;  
      Fnumber(tt,2) = best_k2; 
      Fnumber(tt,3) = best_k3;
end   
      
  optilag(tt,1) = best_p;
  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+tt;
  end

end
  

eps  = real_y-Y_hat; 

% Calcul des m�triques

% M�triques de base
MSPE = mean(eps.^2);
MAPE = mean(abs(eps));

% Coefficients de Theil
THEIL  = sqrt(MSPE)/(sqrt(mean(Y_hat.^2))+sqrt(mean(real_y.^2)));
Tbiais = ((mean(Y_hat)-mean(real_y))^2)/MSPE;
Tvar   = ((std(Y_hat)-std(real_y))^2)/MSPE;
Tcov   = (2*(1-corr(Y_hat,real_y))*std(Y_hat)*std(real_y))/MSPE;


%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diff�rence)
if tcode == 1 | tcode == 4
    Sign = NaN;
else
    
n = size(real_y,1);

[real_pos,junk] = find(real_y>0);
[pred_pos,junk] = find(Y_hat>0);
[positive,junk] = find(real_y>0 & Y_hat>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);

end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y,R,h,rollwind,tcode);
PR2 = 1 - MSPE/MSPEmean;



end
