function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat,eps,Flag,Fnumber,optilag,nvar,VAR_kept1,VAR_kept2,VAR_kept3,Yhat_density] = DIINDEX3(Y,W1,W2,W3,W1_ind,W2_ind,W3_ind,h,type,Pmax,Mmax,Kmax,R,KK,rollwind,tcode,Density)
% Fait une analyse out-of-sample avec un modle  diffusion index



% INPUT
% Y: Variable  prdire
% W: Ensemble de donnes T x K (garder NaN lorsqu'on perd des obs lors de
% transformation)
% h: horizon de la prvision
% Pmax: nombre maximal de retard de la variable  prvoir
% Mmax: nombre de retard des facteurs
% Kmax: nombre maximal de facteurs
% R: Taille de la fentre d'estimation
% type: faon de calculer les facteurs
%    1: Prend toutes les variables
%    2: Utilise le softhreshold de Bai et Ng (2008) (LASSO) (KK variables)
% tcode: Type de prvision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))




% OUTPUT
% MSPE: Moyenne des erreurs de prvision au carr
% MAPE: Moyenne des erreurs de prvision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)
% Flag: Lag des facteurs
% Fnumber: Nb de facteurs
% optilag: nb lag de y




% Transformation selon fortype
if tcode == 1
    Yg = Y; % Y_1  Y_t-h+1
    Yd = Y; % Y_1  Y_t-h+1
    drop = 2;
elseif tcode == 2  
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(Y)]; % Y_1  Y_t-h+1
    drop = 2;
elseif tcode == 3
    Yg = (Y(h+1:end)-Y(1:end-h))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(Y,2)]; % Y_1  Y_t-h+1
    drop = 2;
elseif tcode == 4
    Yg = log(Y); % Y_1  Y_t-h+1
    Yd = log(Y); % Y_1  Y_t-h+1
    drop = 2;
elseif tcode == 5  
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;diff(log(Y))]; % Y_1  Y_t-h+1
    drop = 2;
else
    Yg = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yd = [NaN;NaN;diff(log(Y),2)]; % Y_1  Y_t-h+1
    drop = 2;
end


if size(W2,1) == 0
    nbase = 1;
elseif size(W3,1) == 0
    nbase = 2;
else
    nbase = 3;
end
    
    
T = size(Y,1);
Out_s = T-R;
Kd = length(Density);

% Keep y real values for the prediction error
real_y = Yg(R+1:end);


% Output object
Y_hat = zeros(Out_s,1);
Yhat_density = NaN(Out_s,length(Density));

% Keep information about factor
Flag = NaN(Out_s,3);
Fnumber = NaN(Out_s,3);
optilag = NaN(Out_s,1);
nvar = NaN(Out_s,3);

% Keep information about variable to extract factor

    VAR_kept1 = NaN(Out_s,size(W1,2));
    VAR_kept2 = NaN(Out_s,size(W2,2));
    VAR_kept3 = NaN(Out_s,size(W3,2));



% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les dernires h obs h priode en avance, avec h = 1, 1:R pour prvoir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    

    
    
    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le nombre d'obs manquantes dpend de l'itration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs  dropper ne dpend pas de l'itration dans le cas d'expending
    end
    
    YYg = Yg(dataRange,1); % Y_1  Y_t-h+1
    YYd = Yd(dataRange,1); % Y_1  Y_t-h+1
    
    
    
    if nbase == 1
        kept_ind_1 = W1_ind;
        
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        
        kept_ind_1 = kept_ind_1(1,~any(isnan(WW1),1));
        
        WW1 = WW1(:,~any(isnan(WW1),1));
        
        [WW1,ind1] = unique(WW1','rows');
        kept_ind_1 = kept_ind_1(ind1);
        
        WW1 = WW1';
        
        allB = cell(Pmax,Kmax,Mmax);
    elseif nbase == 2
        kept_ind_1 = W1_ind;
        kept_ind_2 = W2_ind;
        
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        
        kept_ind_1 = kept_ind_1(1,~any(isnan(WW1),1));
        
        WW1 = WW1(:,~any(isnan(WW1),1));
        [WW1,ind1] = unique(WW1','rows');
        
        kept_ind_1 = kept_ind_1(ind1);
        
        WW1 = WW1';
        
        WW2 = W2(dataRange,:);
        WW2 = WW2(1+drop1:end,:);
        
        kept_ind_2 = kept_ind_2(1,~any(isnan(WW2),1));
        
        WW2 = WW2(:,~any(isnan(WW2),1));
        [WW2,ind2] = unique(WW2','rows');
        
        kept_ind_2 = kept_ind_2(ind2);
        
        WW2 = WW2';
        allB = cell(Pmax,Kmax,Kmax,Mmax,Mmax);
    else
        kept_ind_1 = W1_ind;
        kept_ind_2 = W2_ind;
        kept_ind_3 = W3_ind;
        
        WW1 = W1(dataRange,:);
        WW1 = WW1(1+drop1:end,:);
        
        kept_ind_1 = kept_ind_1(1,~any(isnan(WW1),1));
        
        WW1 = WW1(:,~any(isnan(WW1),1));
        [WW1,ind1] = unique(WW1','rows');
        
        kept_ind_1 = kept_ind_1(ind1);
        
        WW1 = WW1';
        
        WW2 = W2(dataRange,:);
        WW2 = WW2(1+drop1:end,:);
        
        kept_ind_2 = kept_ind_2(1,~any(isnan(WW2),1));
        
        WW2 = WW2(:,~any(isnan(WW2),1));
        [WW2,ind2] = unique(WW2','rows');
        
        kept_ind_2 = kept_ind_2(ind2);
        
        WW2 = WW2';
        
        WW3 = W3(dataRange,:);
        WW3 = WW3(1+drop1:end,:);
        
        kept_ind_3 = kept_ind_3(1,~any(isnan(WW3),1));
        
        WW3 = WW3(:,~any(isnan(WW3),1));
        [WW3,ind3] = unique(WW3','rows');
        
        kept_ind_3 = kept_ind_3(ind3);
        
        WW3 = WW3';
        allB = cell(Pmax,Kmax,Kmax,Kmax,Mmax,Mmax,Mmax);
    end
    
 
    
    % Comment calculer les facteurs   (ventuellement changer pour switch)
    if type == 1
        if nbase == 1
            [ehat1,f1,lambda1,ss1]=pc(zscore(WW1),Kmax);
            VAR_kept1(tt,1:size(WW1,2)) = kept_ind_1;
            Kmax1=Kmax;
            keep1=[1,1,1];
        elseif nbase == 2
            [ehat1,f1,lambda1,ss1]=pc(zscore(WW1),Kmax);
            [ehat2,f2,lambda2,ss2]=pc(zscore(WW2),Kmax);
            VAR_kept1(tt,1:size(WW1,2)) = kept_ind_1;
            VAR_kept2(tt,1:size(WW2,2)) = kept_ind_2;
            Kmax1=Kmax;
            Kmax2=Kmax;
            keep1=[1,1,1];
            keep2=[1,1,1];
            
        else
            [ehat1,f1,lambda1,ss1]=pc(zscore(WW1),Kmax);
            [ehat2,f2,lambda2,ss2]=pc(zscore(WW2),Kmax);
            [ehat3,f3,lambda3,ss3]=pc(zscore(WW3),Kmax);
            VAR_kept1(tt,1:size(WW1,2)) = kept_ind_1;
            VAR_kept2(tt,1:size(WW2,2)) = kept_ind_2;
            VAR_kept3(tt,1:size(WW3,2)) = kept_ind_3;
            Kmax1=Kmax;
            Kmax2=Kmax;
            Kmax3=Kmax;
            keep1=[1,1,1];
            keep2=[1,1,1];
            keep3=[1,1,1];
        end
        
        
    else
        if nbase == 1
            keep1 = softreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW1(1:end-h,:),1,KK);
            if length(keep1)<Kmax
                Kmax1 = length(keep1);
            else
                Kmax1 = Kmax;
            end
                
            if isempty(keep1)==0    
                [ehat1,f1,lambda1,ss1]=pc(zscore(WW1(:,keep1)),Kmax1);
                nvar(tt,1) = length(keep1);
                VAR_kept1(tt,1:length(keep1)) = kept_ind_1(keep1);
            end
            
        elseif nbase == 2
            keep1 = softreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW1(1:end-h,:),1,KK);
            if length(keep1)<Kmax
                Kmax1 = length(keep1);
            else
                Kmax1 = Kmax;
            end
            
            if isempty(keep1) == 0
                [ehat1,f1,lambda1,ss1]=pc(zscore(WW1(:,keep1)),Kmax1);
                nvar(tt,1) = length(keep1);
                VAR_kept1(tt,1:length(keep1)) = kept_ind_1(keep1);
            end
            
            
            keep2 = softreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW2(1:end-h,:),1,KK);
            if length(keep2)<Kmax
                Kmax2 = length(keep2);
            else
                Kmax2 = Kmax;
            end
            
             if isempty(keep2) == 0
                [ehat2,f2,lambda2,ss2]=pc(zscore(WW2(:,keep2)),Kmax2);
                nvar(tt,2) = length(keep2);
                VAR_kept2(tt,1:length(keep2)) = kept_ind_2(keep2);
             end
             
        else
           keep1 = softreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW1(1:end-h,:),1,KK);
            if length(keep1)<Kmax
                Kmax1 = length(keep1);
            else
                Kmax1 = Kmax;
            end
            
            
            if isempty(keep1) == 0
                [ehat1,f1,lambda1,ss1]=pc(zscore(WW1(:,keep1)),Kmax1);
                nvar(tt,1) = length(keep1);
                VAR_kept1(tt,1:length(keep1)) = kept_ind_1(keep1);
            end
            
            
            keep2 = softreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW2(1:end-h,:),1,KK);
            if length(keep1)<Kmax
                Kmax2 = length(keep2);
            else
                Kmax2 = Kmax;
            end
            
            
            if isempty(keep2) == 0
                [ehat2,f2,lambda2,ss2]=pc(zscore(WW2(:,keep2)),Kmax2);
                nvar(tt,2) = length(keep2);
                VAR_kept2(tt,1:length(keep2)) = kept_ind_2(keep2);
            end
            
            keep3 = softreshold(YYg(1+drop1+h:end),YYd(1+drop1:end-h,1),WW3(1:end-h,:),1,KK);
            if length(keep3)<Kmax
                Kmax3 = length(keep3);
            else
                Kmax3 = Kmax;
            end

            if isempty(keep3) == 0
                [ehat3,f3,lambda3,ss3]=pc(zscore(WW3(:,keep3)),Kmax3);
                nvar(tt,3) = length(keep3);
                VAR_kept3(tt,1:length(keep3)) = kept_ind_3(keep3);
            end
   
        end
    end
    
if nbase == 1  % Cas avec un seul ensemble de donnes pour facteurs 
   
   % Si aucune variables choisies pour le calcul des facteurs (autorgressif) 
    if isempty(keep1)==1 && type == 2
        BIC = zeros(Pmax,1);
        sigma2 = NaN(Pmax,1);
        
        
            for p = 1:Pmax  

               [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
                XX = [XX, XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   

                                              %  lag 1        lag 2          lag 3              lag p

                % On perd les obs selon drop1
                XX = XX(1+drop1:end,:);

                % Cration de la matrice de variables "indpendantes" et dpendante

                XXXX = [ones(size(XX,1),1),XX];
                YX = [YYg(h+1+drop1:end,1),XXXX];   
                YX = YX(~any(isnan(YX),2),:);  

                % Rgression
                beta = YX(:,2:end)\YX(:,1);
                allB{p,1} = beta;  %crer avant pour la vitesse

                % Fit du in-sample
                par = size(XXXX,2);
                ttt = size(YX,1);

                yin = YX(:,2:end)*beta;
                res = YX(:,1) - yin;
                sigma2(p) = res'*res/(ttt-par);

                % Calcul des critres d'information
                BIC(p,1) = log(sigma2(p))+ par*log(ttt)/ttt;

            end


            if Pmax == 1
                best_p = 1;
            else
                [C,I]   = min(BIC);
                P = ind2sub(size(BIC),I);
                best_p  = P;
            end

              % Cration des variables "indpendantes" pour la prvision
              % Retard de Y

              [y,ylag] = lagML2(YYd,best_p);    
              y = [y(:,1),ylag(:,1:end-1)];
              y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)

              % Variables prdictives
              lastx = [1,y];

              % on prend le bon beta
              fbeta = allB{best_p,1};

              % Prvision
              Y_hat(tt,1) = lastx*fbeta;
              
              sigma = sqrt(sigma2(best_p));
              
              
              for dd = 1:Kd
                  Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
              end

              Flag(tt,1) = 0;
              Fnumber(tt,1) = 0;
              
              
    
    else

            BIC = zeros(Kmax1,Mmax,Pmax);  
            sigma2 = NaN(Kmax1,Mmax,Pmax);
            
            for p = 1:Pmax  

                [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
                 XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                                    %  lag 1        lag 2          lag 3              lag p

                % On perd les obs selon drop1
                XX = XX(1+drop1:end,:);


                for k1 = 1:Kmax1
                    fs1 = f1(:,1:k1);
                    for m1 = 1:Mmax
                        [fsl1,fsllag1] = lagML2(fs1(1:end-h,:),m1); 
                        fsl1 = [fsl1,fsllag1(:,1:end-1*k1)];  % F_{t-2h+1} F_{t-2h+1-1} ...

                        % Cration de la matrice de variables "indpendantes"
                        XXX = [ones(size(fsl1,1),1),XX,fsl1];
                        YX = [YYg(h+1+drop1:end,1),XXX];
                        YX = YX(~any(isnan(YX),2),:);

                        % Rgression
                        beta = YX(:,2:end)\YX(:,1);
                        allB{p,k1,m1} = beta;

                        % Fit du in-sample
                        par = size(XXX,2);
                        ttt = size(YX,1);

                        yin = YX(:,2:end)*beta;
                        res = YX(:,1) - yin;
                        sigma2(k1,m1,p) = res'*res/(ttt-par);

                        % Calcul des critres d'information
                        BIC(k1,m1,p) = log(sigma2(k1,m1,p))+ par*log(ttt)/ttt;

                    end
                end
            end

            minimum = min(min(min(BIC)));


            [K1,M1,P] = ind2sub(size(BIC),find(BIC==minimum));
            best_k1  = K1;
            best_m1  = M1;
            best_p  = P;


              % Cration des variables "indpendantes" pour la prvision
              % Retard de Y

              [y,ylag] = lagML2(YYd,best_p);    
              y = [y(:,1),ylag(:,1:end-1)];
              y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)


              % Retard de F
              [FF1,FFlag1] = lagML2(f1(:,1:best_k1),best_m1);
              FF1 = [FF1,FFlag1(:,1:end-1*best_k1)];
              FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)

              % Variables prdictives
              lastx = [1,y,FF1];

              % on prend le bon beta
              fbeta = allB{best_p,best_k1,best_m1};

              % Prvision
              Y_hat(tt,1) = lastx*fbeta;
              
              sigma = sqrt(sigma2(best_k1,best_m1,best_p));
              
              
              for dd = 1:Kd
                  Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
              end

              
              Flag(tt,1) = best_m1;
              Fnumber(tt,1) = best_k1;
    end
      
elseif nbase == 2 % Cas avec deux ensembles de donnes pour facteurs  

    
     % Si aucune variables choisies pour le calcul des facteurs (autorgressif) 
    if isempty(keep1)==1 || isempty(keep2)==1 && type == 2
        BIC = zeros(Pmax,1);
        sigma2 =  NaN(Pmax,1);
        
        
            for p = 1:Pmax  

               [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
                XX = [XX, XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   

                                              %  lag 1        lag 2          lag 3              lag p

                % On perd les obs selon drop1
                XX = XX(1+drop1:end,:);

                % Cration de la matrice de variables "indpendantes" et dpendante

                XXXX = [ones(size(XX,1),1),XX];
                YX = [YYg(h+1+drop1:end,1),XXXX];   
                YX = YX(~any(isnan(YX),2),:);  

                % Rgression
                beta = YX(:,2:end)\YX(:,1);
                allB{p,1} = beta;  %crer avant pour la vitesse

                % Fit du in-sample
                par = size(XXXX,2);
                ttt = size(YX,1);

                yin = YX(:,2:end)*beta;
                res = YX(:,1) - yin;
                sigma2(p) = res'*res/(ttt-par);

                % Calcul des critres d'information
                BIC(p,1) = log(sigma2(p))+ par*log(ttt)/ttt;

            end


            if Pmax == 1
                best_p = 1;
            else
                [C,I]   = min(BIC);
                P = ind2sub(size(BIC),I);
                best_p  = P;
            end

              % Cration des variables "indpendantes" pour la prvision
              % Retard de Y

              [y,ylag] = lagML2(YYd,best_p);    
              y = [y(:,1),ylag(:,1:end-1)];
              y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)

              % Variables prdictives
              lastx = [1,y];

              % on prend le bon beta
              fbeta = allB{best_p,1};

              % Prvision
              Y_hat(tt,1) = lastx*fbeta;
              
              sigma = sqrt(sigma2(best_p));
              
              
              for dd = 1:Kd
                  Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
              end

              
              Flag(tt,1) = 0;
              Fnumber(tt,1) = 0;
    
    
    
  % Si juste premier lot de variables
    elseif isempty(keep2)==1 && type == 2
       BIC = zeros(Kmax1,Mmax,Pmax);
       sigma2 = NaN(Kmax1,Mmax,Pmax);

            for p = 1:Pmax  

                [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
                 XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                                    %  lag 1        lag 2          lag 3              lag p

                % On perd les obs selon drop1
                XX = XX(1+drop1:end,:);


                for k1 = 1:Kmax1
                    fs1 = f1(:,1:k1);
                    for m1 = 1:Mmax
                        [fsl1,fsllag1] = lagML2(fs1(1:end-h,:),m1); 
                        fsl1 = [fsl1,fsllag1(:,1:end-1*k1)];  % F_{t-2h+1} F_{t-2h+1-1} ...

                        % Cration de la matrice de variables "indpendantes"
                        XXX = [ones(size(fsl1,1),1),XX,fsl1];
                        YX = [YYg(h+1+drop1:end,1),XXX];
                        YX = YX(~any(isnan(YX),2),:);

                        % Rgression
                        beta = YX(:,2:end)\YX(:,1);
                        allB{p,k1,m1} = beta;

                        % Fit du in-sample
                        par = size(XXX,2);
                        ttt = size(YX,1);

                        yin = YX(:,2:end)*beta;
                        res = YX(:,1) - yin;
                        sigma2(k1,m1,p) = res'*res/(ttt-par);

                        % Calcul des critres d'information
                        BIC(k1,m1,p) = log(sigma2(k1,m1,p))+ par*log(ttt)/ttt;

                    end
                end
            end

            minimum = min(min(min(BIC)));


            [K1,M1,P] = ind2sub(size(BIC),find(BIC==minimum));
            best_k1  = K1;
            best_m1  = M1;
            best_p  = P;


              % Cration des variables "indpendantes" pour la prvision
              % Retard de Y

              [y,ylag] = lagML2(YYd,best_p);    
              y = [y(:,1),ylag(:,1:end-1)];
              y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)


              % Retard de F
              [FF1,FFlag1] = lagML2(f1(:,1:best_k1),best_m1);
              FF1 = [FF1,FFlag1(:,1:end-1*best_k1)];
              FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)

              % Variables prdictives
              lastx = [1,y,FF1];

              % on prend le bon beta
              fbeta = allB{best_p,best_k1,best_m1};

              % Prvision
              Y_hat(tt,1) = lastx*fbeta;
              
              sigma = sqrt(sigma2(best_k1,best_m1,best_p));
              
      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end
              
              
              Flag(tt,1) = best_m1;
              Fnumber(tt,1) = best_k1;
        
   % Si juste deuxime lot de variables     
    elseif isempty(keep1) && type == 2
        BIC = zeros(Kmax2,Mmax,Pmax);  
        sigma2 = NaN(Kmax2,Mmax,Pmax);
        
            for p = 1:Pmax  

                [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
                 XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                                    %  lag 1        lag 2          lag 3              lag p

                % On perd les obs selon drop1
                XX = XX(1+drop1:end,:);


                for k2 = 1:Kmax2
                    fs2 = f2(:,1:k2);
                    for m2 = 1:Mmax
                        [fsl2,fsllag2] = lagML2(fs2(1:end-h,:),m2); 
                        fsl2 = [fsl2,fsllag2(:,1:end-1*k2)];  % F_{t-2h+1} F_{t-2h+1-1} ...

                        % Cration de la matrice de variables "indpendantes"
                        XXX = [ones(size(fsl2,1),1),XX,fsl2];
                        YX = [YYg(h+1+drop1:end,1),XXX];
                        YX = YX(~any(isnan(YX),2),:);

                        % Rgression
                        beta = YX(:,2:end)\YX(:,1);
                        allB{p,k2,m2} = beta;

                        % Fit du in-sample
                        par = size(XXX,2);
                        ttt = size(YX,1);

                        yin = YX(:,2:end)*beta;
                        res = YX(:,1) - yin;
                        sigma2(k2,m2,p) = res'*res/(ttt-par);

                        % Calcul des critres d'information
                        BIC(k2,m2,p) = log(sigma2(k2,m2,p))+ par*log(ttt)/ttt;

                    end
                end
            end

            minimum = min(min(min(BIC)));


            [K2,M2,P] = ind2sub(size(BIC),find(BIC==minimum));
            best_k2  = K2;
            best_m2  = M2;
            best_p  = P;


              % Cration des variables "indpendantes" pour la prvision
              % Retard de Y

              [y,ylag] = lagML2(YYd,best_p);    
              y = [y(:,1),ylag(:,1:end-1)];
              y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)


              % Retard de F
              [FF2,FFlag2] = lagML2(f2(:,1:best_k2),best_m2);
              FF2 = [FF2,FFlag2(:,1:end-1*best_k2)];
              FF2 = FF2(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)

              % Variables prdictives
              lastx = [1,y,FF2];

              % on prend le bon beta
              fbeta = allB{best_p,best_k2,best_m2};

              % Prvision
              Y_hat(tt,1) = lastx*fbeta;
              
              sigma = sqrt(sigma2(best_k2,best_m2,best_p));
              
              for dd = 1:Kd
                Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
              end
              
              
              
              Flag(tt,1) = best_m2;
              Fnumber(tt,1) = best_k2;
        
    else
        
        
        % Quand tout est beau
        
    BIC = zeros(Kmax1,Kmax2,Mmax,Mmax,Pmax);  
    sigma2 = NaN(Kmax1,Kmax2,Mmax,Mmax,Pmax);
    
    
    for p = 1:Pmax  
       
        [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
         XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                            %  lag 1        lag 2          lag 3              lag p
        
        % On perd les obs selon drop1
        XX = XX(1+drop1:end,:);                                    
                                            
        for k1 = 1:Kmax1
            fs1 = f1(:,1:k1);
            for k2 = 1:Kmax2
                fs2 = f2(:,1:k2);
                for m1 = 1:Mmax
                    for m2 = 1:Mmax
                        % 1er groupe
                        [fsl1,fsllag1] = lagML2(fs1(1:end-h,:),m1); 
                        fsl1 = [fsl1,fsllag1(:,1:end-1*k1)];  % F_{t-2h+1} F_{t-2h+1-1} ...
                        % 2me groupe
                        [fsl2,fsllag2] = lagML2(fs2(1:end-h,:),m2); 
                        fsl2 = [fsl2,fsllag2(:,1:end-1*k2)];  % F_{t-2h+1} F_{t-2h+1-1} ...

                        
                        % Cration de la matrice de variables "indpendantes"
                        XXX = [ones(size(fsl1,1),1),XX,fsl1,fsl2];
                        YX = [YYg(h+1+drop1:end,1),XXX];
                        YX = YX(~any(isnan(YX),2),:);

                        % Rgression
                        beta = YX(:,2:end)\YX(:,1);
                        allB{p,k1,k2,m1,m2} = beta;

                        % Fit du in-sample
                        par = size(XXX,2);
                        ttt = size(YX,1);

                        yin = YX(:,2:end)*beta;
                        res = YX(:,1) - yin;
                        sigma2(k1,k2,m1,m2,p) = res'*res/(ttt-par);

                        % Calcul des critres d'information
                        BIC(k1,k2,m1,m2,p) = log(sigma2(k1,k2,m1,m2,p))+ par*log(ttt)/ttt;
                    end
                end
            end
        end
    end
    
    minimum  = min(min(min(min(min(BIC)))));
    [K1,K2,M1,M2,P] = ind2sub(size(BIC),find(BIC==minimum));
    best_k1  = K1;
    best_k2 = K2;
    best_m1  = M1;
    best_m2 = M2;
    best_p  = P;
            
           
      % Cration des variables "indpendantes" pour la prvision
      % Retard de Y
      
      [y,ylag] = lagML2(YYd,best_p);    
      y = [y(:,1),ylag(:,1:end-1)];
      y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)
      
      
      % Retard de F1
      [FF1,FFlag1] = lagML2(f1(:,1:best_k1),best_m1);
      FF1 = [FF1,FFlag1(:,1:end-1*best_k1)];
      FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      % Retard de F2
     [FF2,FFlag2] = lagML2(f2(:,1:best_k2),best_m2);
      FF2 = [FF2,FFlag2(:,1:end-1*best_k2)];
      FF2 = FF2(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      % Variables prdictives
      lastx = [1,y,FF1,FF2];
      
      % on prend le bon beta
      fbeta = allB{best_p,best_k1,best_k2,best_m1,best_m2};
      
      % Prvision
      Y_hat(tt,1) = lastx*fbeta;
      
      sigma = sqrt(sigma2(best_k1,best_k2,best_m1,best_m2,best_p));
      
      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end
      
      Flag(tt,1) = best_m1;
      Flag(tt,2) = best_m2;
      Fnumber(tt,1) = best_k1;  
      Fnumber(tt,2) = best_k2; 
    end
    
    
else % Cas avec 3 ensembles de donnes pour facteurs      
    
        
BIC = zeros(Kmax1,Kmax2,Kmax3,Mmax,Mmax,Mmax,Pmax);  
sigma2 = NaN(Kmax1,Kmax2,Kmax3,Mmax,Mmax,Mmax,Pmax);

    for p = 1:Pmax  
       
        [XX,XXlag] = lagML2(YYd(1:end-h,1),p); 
         XX = [XX(:,1), XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   
                                            %  lag 1        lag 2          lag 3              lag p
        
        % On perd les obs selon drop1
        XX = XX(1+drop1:end,:);                                    
                                            
        for k1 = 1:Kmax1
            fs1 = f1(:,1:k1);
            for k2 = 1:Kmax2
                fs2 = f2(:,1:k2);
                for k3 = 1:Kmax3
                    fs3 = f3(:,1:k3);
                    for m1 = 1:Mmax
                        for m2 = 1:Mmax
                            for m3 = 1:Mmax
                                % 1er groupe
                                [fsl1,fsllag1] = lagML2(fs1(1:end-h,:),m1); 
                                fsl1 = [fsl1,fsllag1(:,1:end-1*k1)];  % F_{t-2h+1} F_{t-2h+1-1} ...
                                % 2me groupe
                                [fsl2,fsllag2] = lagML2(fs2(1:end-h,:),m2); 
                                fsl2 = [fsl2,fsllag2(:,1:end-1*k2)];  % F_{t-2h+1} F_{t-2h+1-1} ...
                                % 3me groupe
                                [fsl3,fsllag3] = lagML2(fs3(1:end-h,:),m3); 
                                fsl3 = [fsl3,fsllag3(:,1:end-1*k3)];  % F_{t-2h+1} F_{t-2h+1-1} ...

                                % Cration de la matrice de variables "indpendantes"
                                XXX = [ones(size(fsl1,1),1),XX,fsl1,fsl2,fsl3];
                                YX = [YYg(h+1+drop1:end,1),XXX];
                                YX = YX(~any(isnan(YX),2),:);

                                % Rgression
                                beta = YX(:,2:end)\YX(:,1);
                                allB{p,k1,k2,k3,m1,m2,m3} = beta;

                                % Fit du in-sample
                                par = size(XXX,2);
                                ttt = size(YX,1);

                                yin = YX(:,2:end)*beta;
                                res = YX(:,1) - yin;
                                sigma2(k1,k2,k3,m1,m2,m3,p) = res'*res/(ttt-par);

                                % Calcul des critres d'information
                                BIC(k1,k2,k3,m1,m2,m3,p) = log(sigma2(k1,k2,k3,m1,m2,m3,p))+ par*log(ttt)/ttt;
                            end
                        end
                    end
                end
            end
        end
    end
    
        
    
    minimum  = min(min(min(min(min(min(min(BIC)))))));
    [K1,K2,K3,M1,M2,M3,P] = ind2sub(size(BIC),find(BIC==minimum));
    best_k1 = K1;
    best_k2 = K2;
    best_k3 = K3;
    best_m1 = M1;
    best_m2 = M2;
    best_m3 = M3;
    best_p  = P;
            
           
      % Cration des variables "indpendantes" pour la prvision
      % Retard de Y
      
      [y,ylag] = lagML2(YYd,best_p);    
      y = [y(:,1),ylag(:,1:end-1)];
      y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)
      
      
      % Retard de F1
      [FF1,FFlag1] = lagML2(f1(:,1:best_k1),best_m1);
      FF1 = [FF1,FFlag1(:,1:end-1*best_k1)];
      FF1 = FF1(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      % Retard de F2
     [FF2,FFlag2] = lagML2(f2(:,1:best_k2),best_m2);
      FF2 = [FF2,FFlag2(:,1:end-1*best_k2)];
      FF2 = FF2(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
       % Retard de F2
     [FF3,FFlag3] = lagML2(f3(:,1:best_k3),best_m3);
      FF3 = [FF3,FFlag3(:,1:end-1*best_k3)];
      FF3 = FF3(end,:);  % F_t-h+1 F_t-h+1-1 F_t-h+1-2 ... F_t-h+1-(m-1)
      
      
      % Variables prdictives
      lastx = [1,y,FF1,FF2,FF3];
      
      % on prend le bon beta
      fbeta = allB{best_p,best_k1,best_k2,best_k3,best_m1,best_m2,best_m3};
      
      % Prvision
      Y_hat(tt,1) = lastx*fbeta;
      
      sigma = sqrt(sigma2(best_k1,best_k2,best_k3,best_m1,best_m2,best_m3,best_p));
      
      for dd = 1:Kd
          Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
      end
      
      Flag(tt,1) = best_m1;
      Flag(tt,2) = best_m2;
      Flag(tt,3) = best_m3;
      Fnumber(tt,1) = best_k1;  
      Fnumber(tt,2) = best_k2; 
      Fnumber(tt,3) = best_k3;
end   
      
  optilag(tt,1) = best_p;
  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+tt;
  end

end
  

eps  = real_y-Y_hat; 

% Calcul des mtriques

% Mtriques de base
MSPE = mean(eps.^2);
MAPE = mean(abs(eps));

% Coefficients de Theil
THEIL  = sqrt(MSPE)/(sqrt(mean(Y_hat.^2))+sqrt(mean(real_y.^2)));
Tbiais = ((mean(Y_hat)-mean(real_y))^2)/MSPE;
Tvar   = ((std(Y_hat)-std(real_y))^2)/MSPE;
Tcov   = (2*(1-corr(Y_hat,real_y))*std(Y_hat)*std(real_y))/MSPE;


%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diffrence)
if tcode == 1 | tcode == 4
    Sign = NaN;
else
    
n = size(real_y,1);

[real_pos,junk] = find(real_y>0);
[pred_pos,junk] = find(Y_hat>0);
[positive,junk] = find(real_y>0 & Y_hat>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);

end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y,R,h,rollwind,tcode);
PR2 = 1 - MSPE/MSPEmean;



end

