function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat,eps,Fnumber,Yhat_density] = DIFAVAR(Y,W,h,Pmax,Mmax,Kmax,K,R,rollwind,tcode,Density)
% Fait une analyse out-of-sample avec un FAVAR direct

% INPUT
% Y: variable � pr�voir en niveau
% ind: Indice de la variable � pr�voir dans W
%tcode: code de transformation de la variable � pr�voir
% W: Ensemble de donn�es T x K, il ne doit plus y avoir de valeurs
% manquantes
% h: horizon de la pr�vision
% Mmax: nombre de retard des facteurs
% Kmax: nombre maximal de facteurs pour test de Bai et Ng (2002) (2,2) []
% si on impose K
% K: Nb de facteurs impos�s au lieu du test [] si Bai
% Pmax: nb de lag maximal pour composante idiosyncratique et ADL du
% facteurs
% R: Taille de la fen�tre d'estimation
% tcode: Type de pr�vision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))


% OUTPUT
% MSPE: Moyenne des erreurs de pr�vision au carr�
% MAPE: Moyenne des erreurs de pr�vision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)
% Flag: Lag des facteurs
% Fnumber: Nb de facteurs
% optilag: nb lag de y


% Transformation selon tcode (un vecteur)
Yr = Y;
Yniv1 = Y;
M = size(Y,2);

drop = NaN(1,M);

for kk = 1:M
    if tcode(1,kk) == 1
        drop0 = 0;
        Yr(:,kk) = Y(:,kk); % Y_1 � Y_t-h+1
        Yniv1(:,kk) = Y(:,kk);
    elseif tcode(1,kk) == 2
        drop0 = 1;
         Yr(:,kk) = [NaN(h,1);(Y(h+1:end,kk)-Y(1:end-h,kk))/h]; 
        Yniv1(:,kk) = Y(:,kk);
    elseif tcode(1,kk) == 3
        drop0 = 2;
        Yr1 = (Y(h+1:end,kk)-Y(1:end-h,kk))/h;
        Yr(:,kk) = [NaN(h+1,1);Yr1(2:end)-(Y(1+1:end-h,kk) - Y(1:end-h-1,kk))];
        Yniv1(:,kk) = Y(:,kk);
    elseif tcode(1,kk) == 4
        drop0 = 0;
        Yr(:,kk) = log(Y(:,kk)); % Y_1 � Y_t-h+1
        Yniv1(:,kk) = log(Y(:,kk));
    elseif tcode(1,kk) == 5
        drop0 = 1;
        Yr(:,kk) = [NaN(h,1);(log(Y(h+1:end,kk))-log(Y(1:end-h,kk)))/h]; 
        Yniv1(:,kk) = log(Y(:,kk));
    else
        drop0 = 2;
        Yr1 = (log(Y(h+1:end,kk))-log(Y(1:end-h,kk)))/h;
        Yr(:,kk) = [NaN(h+1,1);Yr1(2:end)-(log(Y(1+1:end-h,kk)) - log(Y(1:end-h-1,kk)))];
        Yniv1(:,kk) = log(Y(:,kk));
    end
    drop(1,kk) = drop0;  
end


drop = max(drop);



T = size(Y,1);
Out_s = T-R;
kd = length(Density);

% Keep y real values for the prediction error
real_y = Yr(R+1:end,:);


% Output object
Y_hat = NaN(Out_s,M);
Yhat_density = NaN(Out_s,M,kd);


% Keep information about factor

Fnumber = zeros(Out_s,1);


% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les derni�res h obs h p�riode en avance, avec h = 1, 1:R pour pr�voir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    
    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le le nombre d'obs manquantes d�pend de l'it�ration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs � dropper ne d�pend pas de l'it�ration dans le cas d'expending
    end
    
    
    Yniv = Yniv1(dataRange,:);
    Yniv = Yniv(1+drop1:end,:);
    
    WW = W(dataRange,:);
    WW = WW(1+drop1:end,:);

    % Estimation des facteurs statiques et moyenne et �cart-type de la
    % variable � pr�voir
    
    if isempty(K) == 1
    % Test de Bai et Ng (2002)
    IC2 = nbplog(WW,Kmax,2,2);
    
        Kstar = IC2;
    else
        Kstar = K;    
    end
    
    
    
    mu = mean(WW);
    sig = std(WW);
    
    
    
    % Pr�vision de chaque facteur avec ADL(P) pour H = 1...h (m�me P?, avec BIC?, nb de facteurs avec test?, bic?...)
    if Kstar == 0
        Ffor = zeros(h,1);
        Lambda = zeros(M,1);
        Idio = zscore(WW);
    else
        Ffor = NaN(h,Kstar);
        [Idio,Fhat,Lambda,junk]=pc(zscore(WW),Kstar);
        for H = 1:h
            [Ffor(H,:),~,MSE{H}] = FACTORADL(Fhat,Mmax,H);
        end
    end
   
    
     for m = 1:M   
        % Pr�vision de la composante idiosyncratique avec AR(p) direct pour H = 1...h, choix
        % du nombre de lag avec BIC
        Idio1 = Idio(:,m);
        idiofor = NaN(h,1);
        

        for H = 1:h
            [idiofor(H,1), FEV_H] = ARD(Idio1,Pmax,H);
            FEV{H}=FEV_H;
        end




        % Construction de la pr�vision selon code de transformation pour
        % obtenir: \Delta^2 \hat{Y}_{t+h}^h = (\hat{Y}_{t+h}-Y_t)/h - (Y_t - Y_{t-1}))
        Lambda1 = Lambda';
        Lambda1 = Lambda1(:,m);
        
        

        if tcode(1,m) == 1 | tcode(1,m) == 4
            forecast_std = sqrt(FEV{h}+Lambda1'*MSE{h}*Lambda1);
            sfac=Ffor(h,:);
            sidio=idiofor(h,1);
            Y_hat(tt,m)=sig(m)*(sfac*Lambda1+sidio)+mu(m);
            
            for dd = 1:kd
                Yhat_density(tt,m,dd) = sig(m)*(Y_hat(tt,m)+Density(dd)*forecast_std)+mu(m);
            end

            

        elseif tcode(1,m) == 2 | tcode(1,m) == 5
            diff1Y = sig(m)*(Ffor*Lambda1+idiofor)+ repmat(mu(m),h,1);
            Y_hat(tt,m)=sum(diff1Y)/h;
            
            for dd = 1:kd
                for hh = 1:h
                    forecast_std = sqrt(FEV{hh}+Lambda1'*MSE{hh}*Lambda1);
                    diff1Y_dens(hh,1) = sig(m)*(diff1Y(hh)+forecast_std*Density(dd))+ mu(m);
                end
            
                Yhat_density(tt,m,dd) = sum(diff1Y_dens)/h;
            end
        

            

        elseif tcode(1,m) == 3 | tcode(1,m) == 6
            mu1=repmat(mu(m),h,1);

            Yd2=(sig(m)*(Ffor*Lambda1+idiofor)+mu1);

            Y_hat(tt,m) = I2toI2h(Yd2,Yniv(end-1:end,m),h);

            for dd = 1:kd
                for hh = 1:h
                    forecast_std = sqrt(FEV{hh}+Lambda1'*MSE{hh}*Lambda1);
                    Yd2_dens(hh,1) = sig(m)*(Yd2(hh)+forecast_std*Density(dd))+ mu(m);
                end
                Yhat_density(tt,m,dd) = I2toI2h(Yd2_dens,Yniv(end-1:end,m),h);
            end        
        
        end


    
     end
  Fnumber(tt,1) = Kstar;
        
  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+tt;
  end

end
  


eps  = real_y-Y_hat; 

% Calcul des m�triques
MSPE = NaN(1,M);
MAPE = NaN(1,M);
THEIL = NaN(1,M);
Tbiais = NaN(1,M);
Tvar = NaN(1,M);
Tcov = NaN(1,M);
Sign = NaN(1,M);
PR2 = NaN(1,M);

for m = 1:M


% M�triques de base
MSPE(1,m) = mean(eps(:,m).^2);
MAPE(1,m) = mean(abs(eps(:,m)));

% Coefficients de Theil
THEIL(1,m)  = sqrt(MSPE(1,m))/(sqrt(mean(Y_hat(:,m).^2))+sqrt(mean(real_y(:,m).^2)));
Tbiais(1,m) = ((mean(Y_hat(:,m))-mean(real_y(:,m)))^2)/MSPE(1,m);
Tvar(1,m)   = ((std(Y_hat(:,m))-std(real_y(:,m)))^2)/MSPE(1,m);
Tcov(1,m)   = (2*(1-corr(Y_hat(:,m),real_y(:,m)))*std(Y_hat(:,m))*std(real_y(:,m)))/MSPE(:,m);


%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diff�rence)
if tcode(1,m) == 1 | tcode(1,m) == 4
    Sign(1,m) = NaN;
else
    
n = size(real_y,1);

[real_pos,junk] = find(real_y(:,m)>0);
[pred_pos,junk] = find(Y_hat(:,m)>0);
[positive,junk] = find(real_y(:,m)>0 & Y_hat(:,m)>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign(1,m) = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);

end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y(:,m),R,h,rollwind,tcode(1,m));
PR2(1,m) = 1 - MSPE(1,m)/MSPEmean;

end

end