function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat,eps,optilag,allcoef,Yhat_density] = ARitforecast(Y,Pmax,h,R,rollwind,tcode,Density)
% Fait une analyse out-of-sample avec un modle AR itratif

% INPUT
% Y: Variable  prdire
% h: horizon de la prvision
% Pmax: nombre maximal de retard de la variable  prvoir. Si Pmax = 1, P
% fix  1, autrement, trouve le p optimal selon BIC ou AIC (on verra
% lequel)
% R: Taille de la fentre d'estimation
% rollwind: Type de fentre
%           1: glissante
%           2: croissante
% tcode: Type de prvision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))



% OUTPUT
% MSPE: Moyenne des erreurs de prvision au carr
% MAPE: Moyenne des erreurs de prvision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)

% Yhat: T-R prvision de la variable d'intrt
% eps: erreur de prvision
% optilag: nb de lags optimal selon 
% coef: coefficient sans constante

% Here I transform the series based on which transformation I choose
% Transformation selon tcode
if tcode == 1
    Yg = Y; % Y_1  Y_t-h+1
    Yr = Y;
    Yniv1 = Y;
    drop = 0;
elseif tcode == 2
    Yg = [NaN;diff(Y)]; % (Y_1-Y_0)  (Y_t-h+1-Y_t-h+1-1)
    Yr = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h]; 
    Yniv1 = Y;
    drop = 1;
elseif tcode == 3
    Yg = [NaN;NaN;diff(Y,2)]; % Y_1  Y_t-h+1
    Yr = (Y(h+1:end)-Y(1:end-h))/h;
    Yr = [NaN(h+1,1);Yr(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yniv1 = Y;
    drop = 2;
elseif tcode == 4
    Yg = log(Y); % Y_1  Y_t-h+1
    Yr = log(Y);
    Yniv1 = log(Y);
    drop = 0;
elseif tcode == 5
    Yg = [NaN;diff(log(Y))]; % (Y_1-Y_0)  (Y_t-h+1-Y_t-h+1-1)
    Yr = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h]; 
    Yniv1 = log(Y);
    drop = 1;
else
    Yg = [NaN;NaN;diff(log(Y),2)]; % Y_1  Y_t-h+1
    Yr = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yr = [NaN(h+1,1);Yr(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1)  (Y_t-h+1-Y_t-h+1-h)
    Yniv1 = log(Y);
    drop = 2;
end

% Time dimension
T = size(Yg,1);

% Out-of-sample size
Out_s = T-R;

Kd = length(Density);

% Keep y real values for the prediction errors
real_y = Yr(R+1:end);


% Output object
Y_hat = zeros(Out_s,1);

Yhat_density = NaN(Out_s,length(Density));

% Lag optimal
optilag = zeros(Out_s,1);

% Valeur des coefficients (sauf la constante)
allcoef = NaN(Out_s,Pmax);

% Beginning loop
% Here I set up the estimation window
% It will update itself automatically (see lines 33-139)
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les dernires h obs h priode en avance, avec h = 1, 1:R pour prvoir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    
   % Here I remove the first few obs since with a first difference you lose
   % on obs and I actually replaced that obs by na when I transformed the
   % series.
    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le nombre d'obs manquantes dpend de l'itration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  % puisque le nombre d'obs  dropper ne dpend pas de l'itration dans le cas d'expending
    end
    
    % I keep the estimation sample
    YYg = Yg(dataRange,1); % Y_1  Y_t-h+1
    Yniv = Yniv1(dataRange,1);
    Yniv = Yniv(end-1:end,1);
    
    [Yhat,best_p,coef,FEV] = ARit(YYg(1+drop1:end,1),Pmax,h);
    % I keep he coefficient, don't remember why
    allcoef(tt,1:length(coef)) = coef;
    
   
    
    for dd = 1:Kd
        Y_density = Yhat+Density(dd)*sqrt(FEV);
        
        if tcode == 1 | tcode == 4
            Yhat_density(tt,dd) = Y_density(end);
        elseif tcode == 2 | tcode == 5
            Yhat_density(tt,dd) = sum(Y_density)/h;
        else
            Yhat_density(tt,dd) = I2toI2h(Y_density,Yniv,h);
        end
    end
    
    if tcode == 1 | tcode == 4
        Y_hat(tt,1) = Yhat(end);
    elseif tcode == 2 | tcode == 5
        Y_hat(tt,1) = sum(Yhat)/h;
    else
        Y_hat(tt,1) = I2toI2h(Yhat,Yniv,h);
    end
        
    optilag(tt,1) = best_p;

    if rollwind == 1
        dataRange = dataRange +1;
    elseif rollwind == 0
        dataRange = 1:R-h+1+tt;
    end
      
end
  

eps  = real_y-Y_hat; 

% Calcul des mtriques

% Mtriques de base
MSPE = mean(eps.^2);
MAPE = mean(abs(eps));

% Coefficients de Theil
THEIL  = sqrt(MSPE)/(sqrt(mean(Y_hat.^2))+sqrt(mean(real_y.^2)));
Tbiais = ((mean(Y_hat)-mean(real_y))^2)/MSPE;
Tvar   = ((std(Y_hat)-std(real_y))^2)/MSPE;
Tcov   = (2*(1-corr(Y_hat,real_y))*std(Y_hat)*std(real_y))/MSPE;


%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diffrence)
if tcode == 1 | tcode == 4
    Sign = NaN;
else
    
n = size(real_y,1);

[real_pos,junk] = find(real_y>0);
[pred_pos,junk] = find(Y_hat>0);
[positive,junk] = find(real_y>0 & Y_hat>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);

end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y,R,h,rollwind,tcode);
PR2 = 1 - MSPE/MSPEmean;



end

