function [Yhat,best_p,coef,FEV] = ARit(y,Pmax,h)
% y: Y_{1}  Y_{t} pour prvoir jusqu' Y_{t+h}
% Pmax: Nombre maximal de lag  considrer
% h: horizon de la prvision

% Yhat: Yhat_{t+1}  Yhat_{t+h}
% best_p: nombre de lag optimal selon BIC
% coef: coefficient sans constante
Yhat = zeros(h,1);

allB = cell(Pmax,1);
BIC = zeros(Pmax,1);


% Dtermination du lag optimal
for p = 1:Pmax  

   [Y,Ylag] = lagML(y,p); 
   
    
    % Cration de la matrice de variables "indpendantes" et dpendante

    X = [ones(size(Ylag,1),1),Ylag];
   
    % Rgression
    beta = X\Y;
    allB{p,1} = beta;  %crer avant pour la vitesse

    % Fit du in-sample
    par = size(beta,1);
    ttt = size(Y,1);

    yin = X*beta;
    res = Y - yin;
    sigma2(p) = res'*res/(ttt-par);

    % Calcul des critres d'information
    BIC(p,1) = log(sigma2(p))+ par*log(ttt)/ttt;

    % Newey-West standard error
    % [nwerr(p)]=nwesterr(Y,X,p);
    
end

if Pmax == 1
    best_p = 1;
else
    [C,I]   = min(BIC);
    P = ind2sub(size(BIC),I);
    best_p  = P;
end

BETA = allB{best_p,1};

% Companion form
Comp = [BETA(2:end)';[eye(best_p-1),zeros(best_p-1,1)]];

% Newey-West standard error
NW_se = sigma2(best_p); %nwerr(best_p); 

% ok
% Forecast error variance
NW_se = ones(best_p,1)*NW_se;
FEV = NW_se;
    
for jj = 1:h-1
    FEV = FEV + Comp^(2*jj)*NW_se;
end
    
FEV = FEV(1,1);



% Prvision
% Setting up the forecast
[Y,Ylag] = lagML(y,best_p);
Ylag = [Y(end) Ylag(end,1:end-1)];

% start
X = [1 Ylag];

for tt = 1:h
    fc = X*BETA;
    Yhat(tt,1) = fc;
   % X = [X(1:end-1) fc];   erreur
    X = [1 fc X(2:end-1)]; %ok
end
    
coef = BETA(2:end)';    
    

end

