function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat,eps,ARcoef,MAcoef,Yhat_density] = ARMAitforecast(Y,p,q,h,R,rollwind,tcode,Density)

% INPUT
% Y: Variable � pr�dire
% h: horizon de la pr�vision
% p: AR
% q: MA
% max_p: When testing the optimal p
% max_q: When testing the optimal q (set to [] if you impose p and q)
% lequel)
% R: Taille de la fen�tre d'estimation
% rollwind: Type de fen�tre
%           1: glissante
%           2: croissante
% tcode: Type de pr�vision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))





% OUTPUT
% MSPE: Moyenne des erreurs de pr�vision au carr�
% MAPE: Moyenne des erreurs de pr�vision absolue
% PR2: Pseudo R^2
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil
% Sign: Test de signes de Perasan et Timmermann (1992)

% Yhat: T-R pr�vision de la variable d'int�r�t
% eps: erreur de pr�vision
% optilag: nb de lags optimal selon 




% Transformation selon tcode
if tcode == 1
    Yg = Y; % Y_1 � Y_t-h+1
    Yr = Y;
    Yniv1 = Y;
    drop = 0;
elseif tcode == 2
    Yg = [NaN;diff(Y)]; % (Y_1-Y_0) � (Y_t-h+1-Y_t-h+1-1)
    Yr = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h))/h]; 
    Yniv1 = Y;
    drop = 1;
elseif tcode == 3
    Yg = [NaN;NaN;diff(Y,2)]; % Y_1 � Y_t-h+1
    Yr = (Y(h+1:end)-Y(1:end-h))/h;
    Yr = [NaN(h+1,1);Yr(2:end,1)-(Y(1+1:end-h) - Y(1:end-h-1))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yniv1 = Y;
    drop = 2;
elseif tcode == 4
    Yg = log(Y); % Y_1 � Y_t-h+1
    Yr = log(Y);
    Yniv1 = log(Y);
    drop = 0;
elseif tcode == 5
    Yg = [NaN;diff(log(Y))]; % (Y_1-Y_0) � (Y_t-h+1-Y_t-h+1-1)
    Yr = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h)))/h]; 
    Yniv1 = log(Y);
    drop = 1;
else
    Yg = [NaN;NaN;diff(log(Y),2)]; % Y_1 � Y_t-h+1
    Yr = (log(Y(h+1:end))-log(Y(1:end-h)))/h;
    Yr = [NaN(h+1,1);Yr(2:end,1)-(log(Y(1+1:end-h)) - log(Y(1:end-h-1)))];   % (Y_h+1-Y_1) � (Y_t-h+1-Y_t-h+1-h)
    Yniv1 = log(Y);
    drop = 2;
end

T = size(Yg,1);
Out_s = T-R;
Kd = length(Density);


% Keep y real values for the prediction error
real_y = Yr(R+1:end);


% Output object
Y_hat = zeros(Out_s,1);
Yhat_density = NaN(Out_s,length(Density));

% Valeur des coefficients (sauf la constante)
ARcoef = NaN(Out_s,p);
MAcoef = NaN(Out_s,q);

% Beginning loop
dataRange = 1:R;
%dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les derni�res h obs h p�riode en avance, avec h = 1, 1:R pour pr�voir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
   
    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le le nombre d'obs manquantes d�pend de l'it�ration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  
    end
    

    YYg = Yg(dataRange,1); % Y_1 � Y_t-h+1
    Yniv = Yniv1(dataRange,1);
    Yniv = Yniv(end-1:end,1);
         
    
    
%     if isempty(p)
%         warning ('off','all');
%         [opt_p,opt_q] = estim_orders_varma_final_ma(YYg(1+drop1:end-h+1,1),0.5,1,10,max_p,max_q,n_T);      
%         if opt_p == 0
%             opt_p = 1;
%         end
%         if opt_q == 0
%             opt_q =1;
%         end
%     else
%         opt_p = p;
%         opt_q = q;
%     end
%         
%     p_vec = 1:opt_p;
%     q_vec = 1:opt_q;
    
    % Shepard functions
      [parameters1, junk, errors,sigma] = armaxfilter(YYg(1+drop1:end-h+1,1), 1, p, q,[]);  %OK
      
      
      %     [yhattph, junk, junk, junk]=arma_forecaster(YYg(1+drop1:end,1), parameters1,1, opt_p, opt_q,length(YYg(1+drop1:end))-2*h+2,h); %ok
%     yhattph = yhattph(end-2*h+1:end-h,1);
%     
   
    % Dalibor's function (actually not his but he gave it to me)
%     [junk,yhattph] = fcst_varma_sequential(x(1:300-h+1),opt_p,opt_q,h,1,delta,c_0,m_T,n_T,ncase);
%     yhattph = yhattph';
%     

    [yhattph] = ARMAit(YYg(1+drop1:end-h+1,1),errors,parameters1,p,q,h);

    % FEV = quelque chose fois sigma.^2
   
     % 2015 vs celle-ci bug
    MAcoef(tt,1) = parameters1(1+1+p:end)';
    ARcoef(tt,1) = parameters1(1+1:p+1)';
   
    
    theta = MAcoef(tt,1); % ma coef
    phi = ARcoef(tt,1); % ar coef 
    
    FEV = 0;
    
    for jj = 0:h-2
        FEV = FEV + (phi^jj*theta+phi^(jj+1));
    end
    
    FEV = sigma^2 + (sigma^2)*FEV;
    
    for dd = 1:Kd
        Y_density = yhattph+Density(dd)*sqrt(FEV);
        
        if tcode == 1 | tcode == 4
            Yhat_density(tt,dd) = Y_density(end);
        elseif tcode == 2 | tcode == 5
            Yhat_density(tt,dd) = sum(Y_density)/h;
        else
            Yhat_density(tt,dd) = I2toI2h(Y_density,Yniv,h);
        end
    end
    
    
    
    
    
    if tcode == 1 | tcode == 4
        Y_hat(tt,1) = yhattph(end,1);
    elseif tcode == 2 | tcode == 5
        Y_hat(tt,1) = sum(yhattph(end-h+1:end,1))/h;
    else
        Y_hat(tt,1) = I2toI2h(yhattph(end-h+1:end,1),Yniv,h);
    end

    if rollwind == 1
        dataRange = dataRange +1;
    elseif rollwind == 0
        dataRange = 1:R+tt;
    end
      
end
  

eps  = real_y-Y_hat; 

% Calcul des m�triques

% M�triques de base
MSPE = mean(eps.^2);
MAPE = mean(abs(eps));

% Coefficients de Theil
THEIL  = sqrt(MSPE)/(sqrt(mean(Y_hat.^2))+sqrt(mean(real_y.^2)));
Tbiais = ((mean(Y_hat)-mean(real_y))^2)/MSPE;
Tvar   = ((std(Y_hat)-std(real_y))^2)/MSPE;
Tcov   = (2*(1-corr(Y_hat,real_y))*std(Y_hat)*std(real_y))/MSPE;


%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diff�rence)
if tcode == 1 | tcode == 4
    Sign = NaN;
else
    
n = size(real_y,1);

[real_pos,junk] = find(real_y>0);
[pred_pos,junk] = find(Y_hat>0);
[positive,junk] = find(real_y>0 & Y_hat>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);

end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y,R,h,rollwind,tcode);
PR2 = 1 - MSPE/MSPEmean;



end



