function [Yhat] = ARMAit(y,errors,parameters,P,Q,h)
% y: Y_{1}  Y_{t} pour prvoir jusqu' Y_{t+h}
% Pmax: Nombre maximal de lag  considrer
% h: horizon de la prvision

% Yhat: Yhat_{t+1}  Yhat_{t+h}
% c = constant coefficient
% Bp = AR coefficients (in column vector)
% Bq = MA coefficients(in column vector)

Yhat = zeros(h,1);

BETA = parameters;

% Prvision
% Setting up the forecast
[Y,Ylag] = lagML(y,P);
Ylag = [Y(end) Ylag(end,1:end-1)];

[E Elag] = lagML(errors,Q);
Elag = [E(end),Elag(end,1:end-1)];

% start
X = [1 Ylag Elag];

for tt = 1:h
    fc = X*BETA;
    Yhat(tt,1) = fc;
    Elag = [0 Elag(1,1:end-1)];
    X = [1 fc X(1,2:P) Elag];
end
        

end

