function [Yhat,FEV] = ARD(y,Pmax,h)
% y: Y_{1}  Y_{t} pour prvoir jusqu' Y_{t+h}
% Pmax: Nombre maximal de lag  considrer
% h: horizon de la prvision

% Yhat: Yhat_{t+1}  Yhat_{t+h}
% best_p: nombre de lag optimal selon BIC


allB = cell(Pmax,1);
BIC = zeros(Pmax,1);


% Dtermination du lag optimal
for p = 1:Pmax  

   [XX,XXlag] = lagML2(y(1:end-h,1),p); 
    XX = [XX, XXlag(:,1:end-1)];  % Y_{t-2h+1} Y_{t-2h+1-1} Y_{t-2h+1-2} ... Y_{t-2h+1-(p-1)   

                                  %  lag 1        lag 2          lag 3              lag p


    % Cration de la matrice de variables "indpendantes" et dpendante

    XXXX = [ones(size(XX,1),1),XX];
    YX = [y(h+1:end,1),XXXX];   
    YX = YX(~any(isnan(YX),2),:);

    % Rgression
    beta = YX(:,2:end)\YX(:,1);
    allB{p,1} = beta;  %crer avant pour la vitesse

    % Fit du in-sample
    par = size(XXXX,2);
    ttt = size(YX,1);

    yin = YX(:,2:end)*beta;
    res = YX(:,1) - yin;
    sigma2{p} = res'*res/(ttt-par);

    % Calcul des critres d'information
    BIC(p,1) = log(sigma2{p})+ par*log(ttt)/ttt;
            
end
    
    
    if Pmax == 1
        best_p = 1;
    else
        [C,I]   = min(BIC);
        P = ind2sub(size(BIC),I);
        best_p  = P;
    end
     
% Cration des variables "indpendantes" pour la prvision
% Retard de Y

[y,ylag] = lagML2(y,best_p);    
y = [y(:,1),ylag(:,1:end-1)];
y = y(end,:);   % Y_t-h+1 Y_t-h+1-1 Y_t-h+1-2 ... Y_t-h+1-(p-1)

% Variables prdictives
lastx = [1,y];

% on prend le bon beta
fbeta = allB{best_p,1};

FEV = sigma2{best_p};

% Prvision
Yhat = lastx*fbeta;

 

end