function [MSPE,MAPE,PR2,THEIL,Tbiais,Tvar,Tcov,Sign,Y_hat,eps,optilag,Yhat_density] = ADLforecast(Y,R,Pmax,h,rollwind,tcode,Density)

% Fait une analyse out-of-sample avec un modle ADL

% INPUT
% Y: Variable  prdire en premire colonne + autres variables
% h: horizon de la prvision
% Pmax: nombre maximal de retard de la variable  prvoir. Si Pmax = 1, P
% fix  1, autrement, trouve le p optimal selon BIC ou AIC (on verra
% lequel)
% R: Taille de la fentre d'estimation
% rollwind: Type de fentre
%           1: glissante
%           2: croissante
% tcode: Type de prvision/transformation
%           1: y_t
%           2: (y_t-y_{t-h})/h
%           3: (y_t-y_{t-h})/h - (y_t-h - y_t-h-1)
%           4: ln(y_t)
%           5: (ln(y_t)-ln(y_{t-h}))/h
%           6: (ln(y_t)-ln(y_{t-h}))/h - (ln(y_t-h) - ln(y_t-h-1))


% OUTPUT
% MSPE: Moyenne des erreurs de prvision au carr
% MAPE: Moyenne des erreurs de prvision absolue
% THEIL: Coefficient de Theil
% Tbiais: Biais proportion de Theil
% Tvar: Variance proportion de Theil
% Tcov: Covariance proportion de Theil


% Yhat: T-R prvision de la variable d'intrt
% eps: erreur de prvision
% lag: nb de lags choisi (K colonnes)


[T,K] = size(Y);
Out_s = T-R;
Kd = length(Density);


% Transformation selon fortype
Yd = Y;
drop = NaN(1,K);

for kk = 1:K
    if tcode(1,kk) == 1
        Yd(:,kk) = Y(:,kk); % Y_1  Y_t-h+1
        drop0 = 0;
    elseif tcode(1,kk) == 2
        Yd(:,kk) = [NaN(1,1);diff(Y(:,kk))]; 
        drop0 = 1;
    elseif tcode(1,kk) == 3
        Yd(:,kk) = [NaN(2,1);diff(Y(:,kk),2)]; % Y_1  Y_t-h+1
        drop0 = 2;
    elseif tcode(1,kk) == 4
        Yd(:,kk) = log(Y(:,kk)); 
        drop0 = 0;
    elseif tcode(1,kk) == 5
        Yd(:,kk) = [NaN(1,1);diff(log(Y(:,kk)))]; 
        drop0 = 1;
    else
        Yd(:,kk) = [NaN(2,1);diff(log(Y(:,kk)),2)]; % Y_1  Y_t-h+1
        drop0 = 2;
    end
    drop(1,kk) = drop0;  
end


if tcode(1,1) == 1
    Yg = Y(:,1); % Y_1  Y_t-h+1
    
elseif tcode(1,1) == 2
    Yg = [NaN(h,1);(Y(h+1:end,1)-Y(1:end-h,1))/h]; 
    
elseif tcode(1,1) == 3
    Yg = (Y(h+1:end,1)-Y(1:end-h,1))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(Y(1+1:end-h,1) - Y(1:end-h-1,1))];
    
elseif tcode(1,1) == 4
    Yg = log(Y(:,1)); % Y_1  Y_t-h+1
    
elseif tcode(1,1) == 5
    Yg = [NaN(h,1);(log(Y(h+1:end,1))-log(Y(1:end-h,1)))/h]; 
    
else
    Yg = (log(Y(h+1:end,1))-log(Y(1:end-h,1)))/h;
    Yg = [NaN(h+1,1);Yg(2:end,1)-(log(Y(1+1:end-h,1)) - log(Y(1:end-h-1,1)))];
end

drop = max(drop);
Yhat_density = NaN(Out_s,length(Density));


% Keep y real values for the prediction error
real_y = Yg(R+1:end,1);

% Output object
Y_hat = zeros(Out_s,1);
optilag = zeros(Out_s,K);

% Beginning loop
dataRange = 1:R-h+1;  % -h puisqu'on n'a pas les dernires h obs h priode en avance, avec h = 1, 1:R pour prvoir l'obs suivant directement la fenetre d'estimation
for tt = 1:Out_s
    
   
    % Ici c'est pour prendre en compte que celon I(0),I(1),I(2) on va avoir
    % moins d'observations pour les une ou deux premires prvisions d au
    % ct droit de l'quation dans le cas rolling
    if rollwind == 1 
        if tt < drop+1
            drop1 = drop-(tt-1); %puisque le le nombre d'obs manquantes dpend de l'itration pour rolling
        else
            drop1 = 0;
        end
    else
        drop1 = drop;  
    end
    
   
    YYg = Yg(dataRange,:); % Y_1  Y_t-h+1
    YYd = Yd(dataRange,:); % Y_1  Y_t-h+1
    
    
    [X,Xlag] = lagML2(YYd(1:end-h,:),Pmax); 
     X = [X, Xlag(:,1:end-K)];
    
     
    
     possible_lag = 1:Pmax*K;
     possible_lag = reshape(possible_lag,K,Pmax)';
     
     possible = repmat([1:Pmax]',1,K);
     
     plag = reshape(possible,1,(Pmax)*K);
     
     %ALL_possible_lag_combination = combntns(plag,K);
     ALL_possible_lag_combination = nchoosek(plag,K);
     
     % Toutes les combinaisons possibles de lag de K variables
     ALL_possible_lag_combination = unique(ALL_possible_lag_combination,'rows');
     
     BIC = zeros(size(ALL_possible_lag_combination,1),1);
     allB = cell(size(ALL_possible_lag_combination,1),1);
     
     for pp = 1:size(ALL_possible_lag_combination,1);
     
         comb = ALL_possible_lag_combination(pp,:);
         
         b = [];
         for ii = 1:K
            a = possible_lag(1:comb(1,ii),ii);
            b = [b a'];
         end
         
         choice = sort(b);
         XX = X(:,choice);
     
     
        % Cration de la matrice de variables "indpendantes"
        allX = [ones(size(XX,1),1) XX];

        allX = allX(1+drop1:end,:);

        YX = [YYg(h+1+drop1:end,1),allX];
        YX = YX(~any(isnan(YX),2),:);  

        % Rgression
        beta = YX(:,2:end)\YX(:,1);
        allB{pp,1} = beta;  %crer avant pour la vitesse
        
        
        % Fit du in-sample
        par = size(allX,2);
        ttt = size(YX,1);

        yin = YX(:,2:end)*beta;
        res = YX(:,1) - yin;
        sigma2{pp} = res'*res/(ttt-par);
 
        % Calcul des critres d'information
        BIC(pp,1) = log(sigma2{pp})+ par*log(ttt)/ttt;

        
     end                             
                                
                                
                                
    
  [junk, minBIC]  = min(BIC);
   

  % Cration des variables "indpendantes" pour la prvision
  best_comb = ALL_possible_lag_combination(minBIC,:);
  
  
 b = [];
     for ii = 1:K
        a = possible_lag(1:best_comb(1,ii),ii);
        b = [b a'];
     end
     best_choice = sort(b);
     
    [X,Xlag] = lagML2(YYd,Pmax); 
     X = [X, Xlag(:,1:end-K)];
     XX = X(:,best_choice);


  
  % Variables prdictives
  lastx = [1,XX(end,:)];

  
  % on prend le bon beta
  beta = allB{minBIC,1};
  
  % Forecast error std
  sigma = sqrt(sigma2{minBIC});

  % Prvision
  Y_hat(tt,1) = lastx*beta;
  
  
  for dd = 1:Kd
      Yhat_density(tt,dd) = Y_hat(tt,1)+Density(dd)*sigma;
  end

  
  
  optilag(tt,:) = best_comb;
  
  if rollwind == 1
      dataRange = dataRange +1;
  elseif rollwind == 0
      dataRange = 1:R-h+1+tt;
  end
end
  

eps  = real_y-Y_hat; 

% Calcul des mtriques

% Mtriques de base
MSPE = mean(eps.^2);
MAPE = mean(abs(eps));

% Coefficients de Theil
THEIL  = sqrt(MSPE)/(sqrt(mean(Y_hat.^2))+sqrt(mean(real_y.^2)));
Tbiais = ((mean(Y_hat)-mean(real_y))^2)/MSPE;
Tvar   = ((std(Y_hat)-std(real_y))^2)/MSPE;
Tcov   = (2*(1-corr(Y_hat,real_y))*std(Y_hat)*std(real_y))/MSPE;


%Test de signes de Perasan et Timmermann (1992) (seulement pour variable en
%diffrence)
if tcode == 1 | tcode == 4
    Sign = NaN;
else
    
n = size(real_y,1);

[real_pos,junk] = find(real_y>0);
[pred_pos,junk] = find(Y_hat>0);
[positive,junk] = find(real_y>0 & Y_hat>0);

rho_y = mean(real_pos);
rho_x = mean(pred_pos);
rhohat = mean(positive);
rhohat_star = rho_y*rho_x+(1-rho_y)*(1-rho_x);

Vrho = rhohat_star*(1-rhohat_star)/n;
Vrho_star = (2*rho_y-1)^2*rho_x*(1-rho_x)/n + (2*rho_x-1)^2*rho_y*(1-rho_y)/n + 4*rho_y*rho_x*(1-rho_y)*(1-rho_x)/(n^2);

Sign = (rhohat-rhohat_star)/sqrt(Vrho-Vrho_star);

end

% Pseudo R^2

[MSPEmean,junk,junk,junk] = meanforecast(Y(:,1),R,h,rollwind,tcode(1,1));
PR2 = 1 - MSPE/MSPEmean;


end


