allData=readtable('histTermPremium.csv');

timeline=(1984.25:0.25:2020);
timeline1=(1984.25:0.25:2008);

patch_time = [timeline flipdim(timeline,2)]'; 

dat_temp=[allData.Var2 allData.Var3 allData.Var4 allData.Var5 allData.Var6 allData.Var7 allData.Var8 allData.Var9 allData.Var10 allData.Var11 allData.Var12];

bench_result=dat_temp(:,9);
bench_longresult=dat_temp(:,10);
new_longresult=dat_temp(:,11);


min_y=min(dat_temp(:,1:8)');
max_y=max(dat_temp(:,1:8)');

min_y2=min(dat_temp(:,[1:8])');
max_y2=max(dat_temp(:,[1:8])');


RGB_wide = [.85 .85 .85]; % color for the outer area
RGB_edge_wide = [.85 .85 .85]; % color for the edge of the outer area
RGB_middle = [.85 .85 .85]; % color for the midlle area
RGB_edge_middle = [.85 .85 .85]; % color for edge of the middle area
RGB_close = [.6 .6 .6]; % color for the inner area
RGB_edge_close = [.5 .5 .5]; % color for the edge of the inner area


figure('Name','TermPremium','Position',[50 50 1000 600]); 
            
            plot(timeline1, bench_result(1:size(timeline1,2)), 'k', 'Linewidth', 2);
            hold on
            
            Hpatch2  = [patch_time [min_y2';flipdim(max_y2,2)']];
            patch(Hpatch2(:,1),Hpatch2(:,2),RGB_middle,'edgecolor',RGB_edge_middle);
           
            %Median and zero line:     
           plot(timeline1, bench_result(1:size(timeline1,2)), 'k', 'Linewidth', 2);
            plot(timeline(90:end), bench_longresult(90:end), '--r', 'Linewidth', 2);
           
            % Recover vertical axis:
            line([1984.25 1984.25],[min_y2(1) max_y2(1)], 'Color','k');
            line([2020 2020],[min_y2(end) max_y2(end)], 'Color','k');
           
         axis([1984.25 2020 -1 7])
          ylabel('Nominal 10-year term premium in %','FontSize',12);
         xlabel('Year','FontSize',12);
          
            set(gca,'FontSize',14); 
          set(gcf,'PaperPositionMode','auto')
  
h = breakxaxis([2006 2008]); 
print('-depsc2','Fig1');

%%   
figure('Name','TermPremium','Position',[50 50 1000 600]); 
            
            plot(timeline1, bench_result(1:size(timeline1,2)), 'k', 'Linewidth', 2);
            hold on
            
            Hpatch2  = [patch_time [min_y2';flipdim(max_y2,2)']];
            patch(Hpatch2(:,1),Hpatch2(:,2),RGB_middle,'edgecolor',RGB_edge_middle);
           
            %Median and zero line:     
           plot(timeline1, bench_result(1:size(timeline1,2)), 'k', 'Linewidth', 2);
            plot(timeline(90:end), bench_longresult(90:end), '--r', 'Linewidth', 2);
    plot(timeline, new_longresult, '-o', 'Linewidth', 2);
          
            % Recover vertical axis:
            line([1984.25 1984.25],[min_y2(1) max_y2(1)], 'Color','k');
            line([2020 2020],[min_y2(end) max_y2(end)], 'Color','k');
           
         axis([1984.25 2020 -1 7])
        
         ylabel('Nominal 10-year term premium in %','FontSize',12);
         xlabel('Year','FontSize',12);
            
            set(gca,'FontSize',14); 
          set(gcf,'PaperPositionMode','auto')
h = breakxaxis([2006 2008]); 

   print('-depsc2','Fig6_Appendix');
