clear;clc;close all;


%Calculate Multiplier for different values
%for the G-Y Elasticity

egy=zeros(11,1);
egy(1,1)=-0.5;
for i=2:size(egy,1);
    egy(i,1)=egy(i-1)+0.1;
end

for j=1:size(egy,1);
    thisegy=egy(j,1);
    [mulzlb,mul,mulzlb68l,mulzlb68u,mulzlb90l,mulzlb90u,...
    mul68l,mul68u,mul90l,mul90u,...
    dif,dif68l,dif68u,dif90l,dif90u]=getmultiplier(thisegy);
    thismulzlb(:,j)=mulzlb;
    thismul(:,j)=mul;
    thisdif(:,j)=dif;
    thismulzlb68l(:,j)=mulzlb68l;
    thismulzlb68u(:,j)=mulzlb68u;
    thismulzlb90l(:,j)=mulzlb90l;
    thismulzlb90u(:,j)=mulzlb90u;
    thismul68l(:,j)=mul68l;
    thismul68u(:,j)=mul68u;
    thismul90l(:,j)=mul90l;
    thismul90u(:,j)=mul90u;
    thisdif68l(:,j)=dif68l;
    thisdif68u(:,j)=dif68u;
    thisdif90l(:,j)=dif90l;
    thisdif90u(:,j)=dif90u;
end
mulzlb=thismulzlb;
mul=thismul;
dif=thisdif;
mulzlb68l=thismulzlb68l;
mulzlb68u=thismulzlb68u;
mulzlb90l=thismulzlb90l;
mulzlb90u=thismulzlb90u;
mul68l=thismul68l;
mul68u=thismul68u;
mul90l=thismul90l;
mul90u=thismul90u;
dif68l=thisdif68l;
dif68u=thisdif68u;
dif90l=thisdif90l;
dif90u=thisdif90u;

hor=4;
zz=zeros(1,size(egy,1));

set(0,'DefaultAxesFontName','Times');
set(0,'DefaultAxesFontSize',10);

figure(1)
subplot(2,3,1)
plot(egy,mulzlb(1,:),'r-o','LineWidth', 1.5);
hold on
plot(egy,mulzlb90l(1,:),'r--');
hold on
plot(egy,mulzlb90u(1,:),'r--');
hold on
plot(egy, zz', 'r:','LineWidth', 0.5);
title('ZLB')
ylim([-0.5 2])
subplot(2,3,2)
plot(egy,mul(1,:),'r-o','LineWidth', 1.5);
hold on
plot(egy,mul90l(1,:),'r--');
hold on
plot(egy,mul90u(1,:),'r--');
hold on
plot(egy, zz', 'r:','LineWidth', 0.5);
title('Outside ZLB')
ylim([-0.5 2])
subplot(2,3,3)
plot(egy,dif(1,:),'r-o','LineWidth', 1.5);
hold on
plot(egy,dif90l(1,:),'r--');
hold on
plot(egy,dif90u(1,:),'r--');
hold on
plot(egy, zz', 'r:','LineWidth', 0.5);
title('Difference')
ylim([0.5 1.75])


figure(2)
subplot(2,3,1)
plot(egy,mulzlb(3,:),'r-o','LineWidth', 1.5);
hold on
plot(egy,mulzlb90l(3,:),'r--');
hold on
plot(egy,mulzlb90u(3,:),'r--');
hold on
plot(egy, zz', 'r:','LineWidth', 0.5);
title('ZLB')
ylim([-0.5 2.5])
subplot(2,3,2)
plot(egy,mul(3,:),'r-o','LineWidth', 1.5);
hold on
hold on
plot(egy,mul90l(3,:),'r--');
hold on
plot(egy,mul90u(3,:),'r--');
hold on
plot(egy, zz', 'r:','LineWidth', 0.5);
title('Outside ZLB')
ylim([-0.5 2.5])
subplot(2,3,3)
plot(egy,dif(3,:),'r-o','LineWidth', 1.5);
hold on
plot(egy,dif90l(3,:),'r--');
hold on
plot(egy,dif90u(3,:),'r--');
hold on
plot(egy, zz', 'r:','LineWidth', 0.5);
title('Difference')
ylim([0.25 1.85])
set(gcf,'PaperPosition',[0.63 0.63 19.72 14.41]);

figure(3)
subplot(2,3,1)
plot(egy,mulzlb(5,:),'r-o','LineWidth', 1.5);
hold on
plot(egy,mulzlb90l(5,:),'r--');
hold on
plot(egy,mulzlb90u(5,:),'r--');
hold on
plot(egy, zz', 'r:','LineWidth', 0.5);
title('ZLB')
ylim([-0.75 3])
subplot(2,3,2)
plot(egy,mul(5,:),'r-o','LineWidth', 1.5);
hold on
plot(egy,mul90l(5,:),'r--');
hold on
plot(egy,mul90u(5,:),'r--');
hold on
hold on
plot(egy, zz', 'r:','LineWidth', 0.5);
title('Outside ZLB')
ylim([-0.75 3])
subplot(2,3,3)
plot(egy,dif(5,:),'r-o','LineWidth', 1.5);
hold on
plot(egy,dif90l(5,:),'r--');
hold on
plot(egy,dif90u(5,:),'r--');
hold on
plot(egy, zz', 'r:','LineWidth', 0.5);
title('Difference')
ylim([0 2.2])
set(gcf,'PaperPosition',[0.63 0.63 19.72 14.41]);

