
function [years,y,g,t,r,ex,p,infl,ly,lg,lt,ls,ld,lex,lp,countries,ifs,year,crisis,lrate,mgov,mpers,Dmgov,wardummy,mgov2,taxrate,infl2,...
    eq_tr,eq_capgain,capital_tr,risky_tr,safe_tr]=getdata_jst_panel

vdata = xlsread('Data_R.xlsx',1);
time=vdata(:,1);
countries=13;
years=size(vdata,1)/countries;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%IMPORTANT INPUT (sample window)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DATA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
year=vdata(:,1);            %Year
ncountry=vdata(:,2);        %Country
iso=vdata(:,3);             %ISO 3-letter code
ifs=vdata(:,4);             %IFS 3-number country-code
pop=vdata(:,5);             %Population
rgdpmad=vdata(:,6);         %Real GDP per capita (PPP)
rgdppc=vdata(:,7);          %Real GDP per capita (index, 2005=100)
rconpc=vdata(:,8);          %Real consumption per capita (index, 2006=100)
gdp=vdata(:,9);             %GDP (nominal, local currency)
iy=vdata(:,10);             %Investment-to-GDP ratio
cpi=vdata(:,11);            %Consumer prices (index, 1990=100)
ca=vdata(:,12);             %Current account (nominal, local currency)
imports=vdata(:,13);        %Imports (nominal, local currency)
exports=vdata(:,14);        %Exports (nominal, local currency)
narrowm=vdata(:,15);        %Narrow money (nominal, local currency)
money=vdata(:,16);          %Broad money (nominal, local currency)
stir=vdata(:,17);           %Short-term interest rate (nominal, percent per year)
ltrate=vdata(:,18);         %Long-term interest rate (nominal, percent per year)
stocks=vdata(:,19);         %Stock prices (nominal index)
debtgdp=vdata(:,20);        %Public debt-to-GDP ratio
revenue=vdata(:,21);        %Government revenues (nominal, local currency)
expenditure=vdata(:,22);	%Government expenditure (nominal, local currency)
xrusd=vdata(:,23);          %USD exchange rate (local currency/USD)
crisisJST=vdata(:,24);      %Systemic financial crises (0-1 dummy)
tloans=vdata(:,25);         %Total loans to non-financial private sector (nominal, local currency)
tmort=vdata(:,26);          %Mortgage loans to non-financial private sector (nominal, local currency)
thh=vdata(:,27);            %Total loans to households (nominal, local currency)
tbus=vdata(:,28);           %Total loans to business (nominal, local currency)
hpnom=vdata(:,29);          %House prices (nominal index, 1990=100)
milex=vdata(:,30);          %Military expenditures
milpers=vdata(:,31);        %Military persons

wardummy=vdata(:,32);       %War dummy
milex_sipri=vdata(:,33);    %Military expenditure (SIPRI) /  in constant (2016) US$ m
milex_sipri2=vdata(:,34);   %Military expenditure (SIPRI) / local currency, calendar years

eq_tr=vdata(:,35);          %Equity total return
eq_capgain=vdata(:,36);     %Equity capital gain
capital_tr=vdata(:,37);     %Toral return on wealth
risky_tr=vdata(:,38);       %Total return on risky assets
safe_tr=vdata(:,39);        %Toral return on safe assets

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%DATA TRANSFORMATION
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Mrgdppc=reshape(rgdppc,[years,countries]);
Mgdp=reshape(gdp,[years,countries]);
Mpop=reshape(pop,[years,countries]);

% real gdp pc in local currency prices of 2005
for i=1:countries
    baseperiod(:,i)=find(Mrgdppc(:,i)==100);
    My(:,i)=(Mrgdppc(:,i)./100).*(Mgdp(baseperiod(:,i),i).*1e9)./(Mpop(baseperiod(:,i),i).*1e3);
    
end

y=reshape(My,[countries*years,1]);  % real gdp pc in local currency prices of 2005

yn=gdp*1e9./(pop*1e3);              % nominal gdp pc 
py=yn./y;                           % the implicit deflator

rgov=(expenditure*1e9)./(pop*1e3)./cpi.*100; %./(py);       %Real government expenditure per capita
%  deflated with implicit gdp deflator

%rtax=(revenue./gdp);                 %Nominal government revenues over nominal GDP
taxrate=100.*(revenue./(rgdppc.*pop.*cpi));
rtax=(revenue*1e9)./(pop*1e3)./cpi.*100;
rstocks=(stocks./(cpi));         %Real stock prices per capita


xrusd1=1./xrusd;


milexnew=milex;
for i=1:size(milex,1)
    if milex(i,:)<=0
        milexnew(i,:)=1;
    end
end
milex=abs(milex)+1;
rmilex=((milex.*xrusd))./cpi./pop;

rmilex_sipri=(milex_sipri.*xrusd)./(pop);

rmilex2=rmilex;
for i=1:size(rmilex2,1)
    if rmilex_sipri(i,:)>0
        rmilex2(i,:)=rmilex_sipri(i,:);
    end
end

%  rmilex2=rmilex_sipri;
%  for i=1:size(rmilex2,1)
%      if  rmilex(i,:)>0
%          rmilex2(i,:)=rmilex(i,:);
%      end
%  end



g=(rgov);
d=(debtgdp);
t=(rtax);
s=(rstocks);
r=(stir);
ex=(xrusd);
p=(cpi);
y=y;
lrate=ltrate;
mgov=rmilex;
mgov2=rmilex2;

mpers=(abs(milpers)+1)./pop;

ly=log(y);
lg=log(g);
lt=log(t);
ls=(s);
ld=log(d);
lex=log(ex);
lp=log(cpi);


MDinfl = reshape((p),[years,countries]);
MDinfl(2:end,:) = MDinfl(2:end,:)-MDinfl(1:end-1,:); 
MDinfl(1,:) = 0;
infl = reshape(MDinfl,[countries*years,1]);

MDinfl2 = reshape((p),[years,countries]);
MDinfl2(1:end-1,:) = MDinfl2(2:end,:)-MDinfl2(1:end-1,:); 
MDinfl2(end,:) = 0;
infl2 = reshape(MDinfl2,[countries*years,1]);

MDmgov = reshape((mgov2),[years,countries]);
MMy=reshape(ly,[years,countries]);
MDmgov(2:end,:) = (log(MDmgov(2:end,:))-log(MDmgov(1:end-1,:)))./MMy(1:end-1,:); 
MDmgov(1,:) = 0;
Dmgov = reshape(MDmgov,[countries*years,1]);
Dmgov=Dmgov;


crisis=crisisJST;


end