clear;clc;close all;

%-------------------------------------------------------------------
% call getdata.m to fetch the data, adjust the getdata.m function if
% different / more variables shall be used
%-------------------------------------------------------------------
[years,y,g,t,r,ex,p,infl,ly,lg,lt,ls,ld,lex,lp,countries,ifs,year,crisis,lrate,mgov,mpers,Dmgov,wardummy,mgov2]=getdata_jst_panel;

%Specify time period
Myear=reshape(year,[years,countries]);
t1=find(Myear(:,1)==1917);              %Start date
t2=find(Myear(:,1)==2016);              %End date

y=cutsample(t1,t2,y);
g=cutsample(t1,t2,g);
t=cutsample(t1,t2,t);
r=cutsample(t1,t2,r);
ex=cutsample(t1,t2,ex);
p=cutsample(t1,t2,p);
infl=cutsample(t1,t2,infl);
ly=cutsample(t1,t2,ly);
lg=cutsample(t1,t2,lg);
mgov2=cutsample(t1,t2,mgov2.*100);
lmg=log(mgov2);
Dmgov=cutsample(t1,t2,Dmgov.*100);
lt=cutsample(t1,t2,lt);
ls=cutsample(t1,t2,ls);
ld=cutsample(t1,t2,ld);
lex=cutsample(t1,t2,lex);
lp=cutsample(t1,t2,lp);
year=cutsample(t1,t2,year);
crisis=cutsample(t1,t2,crisis);
lrate=cutsample(t1,t2,lrate);
ifs=cutsample(t1,t2,ifs);
wardummy=cutsample(t1,t2,wardummy);

years=size(y,1)./countries;


Mr=reshape(r,[years,countries]);
Myear=reshape(year,[years,countries]);
threshold=ones(length(Mr),1);
figure(1);
plot(Myear(:,1), Mr(:,1),'-d');
hold on
plot(Myear(:,2), Mr(:,2),'-o');
hold on
plot(Myear(:,3), Mr(:,3),'-+');
hold on
plot(Myear(:,4), Mr(:,4), '-x');
hold on
plot(Myear(:,5), Mr(:,5), '->');
hold on
plot(Myear(:,6), Mr(:,6), '-<');
hold on
plot(Myear(:,7), Mr(:,7), '-v');
hold on
plot(Myear(:,8), Mr(:,8), '-h');
hold on
plot(Myear(:,9), Mr(:,9), '-p');
hold on
plot(Myear(:,10), Mr(:,10), '-*');
hold on
plot(Myear(:,11), Mr(:,11), '-s');
hold on
plot(Myear(:,12), Mr(:,12), '-x');
hold on
plot(Myear(:,13), Mr(:,13),'-^');
hold on
plot(Myear(:,13), threshold+0.075,'-k');
axis([1917 2016 -1 22])
lgd=legend('BEL','CHE','DNK','ESP','FIN','FRA','GBR','ITA','NLD','NOR','PRT','SWE','USA');
lgd.FontSize = 7;
% set(gcf,'PaperPosition',[0.63 0.63 19.72 10.41/1]);
% print(figure(1),'-depsc2','-r2500','-painters', 'InterestRates.eps');
% print(figure(1),'-dpdf',  '-r2500','-painters', 'InterestRates.pdf');

