clear all
set more off

cd "F:\Research\RR"

forvalues i = 1(1)1000{
import delimited "F:\Research\RR\dgp`i'.csv", colrange(1:40) clear /*load simulated data for estimation*/

forvalues t = 1(1)10{
local i_k = `t'
rename v`i_k' k`t'

local i_l = 10 + `t'
rename v`i_l' l`t'

local i_m = 20 + `t'
rename v`i_m' m`t'

local i_y = 30 + `t'
rename v`i_y' y`t'
}

gen id = _n /*generate firm id*/
save dgp1_simulation.dta, replace

/*start estimation*/

local dlwprogram = "acf_mata_original.do" 

do `dlwprogram'

use dgp1_simulation.dta, clear 
reshape long k l m y, i(id) j(t)
xtset id t


*------FIRST STAGE----------------------------------------------------------*
xi: reg y l m k /*robust to higher order polynomial*/

predict phi
predict epsilon, res

label var phi "phi_it 
label var epsilon "measurement error first stage
gen phi_lag=L.phi
gen l_lag=L.l
gen k_lag=L.k

*--------------------------------------------------------------------------------------------------*
sort id t
gen const=1
drop if y==.
drop if l_lag==.
drop if k==.

*----------------------------------------------------------------------------------------------------

*------PLUG IN TRUE VALUES AS STARTING VALUES--------------------------------------------------------
local starting = 7
gen initialConst = 0

forvalues s = 7(1)`starting'{
gen initiall = 0.1*(`s'-1)
gen initialk = 0.1*(11-`s')

dlw /*start search*/

putexcel A`s' = mat(beta_dlw) using acf_replicate, sheet("dgp1_`i'") modify /*save results to excel*/

drop initiall initialk
}

local i = `i' + 1
}

*step 3: IMPORT RESULTS TO STATA DATA FILE

import excel "F:\Research\RR\acf_replicate.xlsx",sheet("dgp1_1") clear
sort C
keep if _n == 1
save result_acf_replicate.dta, replace

local loop = 2

while `loop' < = 1000{

import excel "F:\Research\RR\acf_replicate.xlsx",sheet("dgp1_`loop'") clear
sort C
keep if _n == 1
save result_temp.dta, replace

append using result_acf_replicate.dta

save result_acf_replicate.dta, replace 

local loop = `loop' + 1
}


















