clear
clear mata
clear matrix

mata:
void GMM_DLW(todo,betas,crit,g,H)
{
	PHI=st_data(.,("phi"))
    PHI_LAG=st_data(.,("phi_lag"))
    Z=st_data(.,("const","l_lag","k"))
    X=st_data(.,("l","k"))
    X_lag=st_data(.,("l_lag","k_lag"))
    Y=st_data(.,("y"))
	C=st_data(.,("const"))
	betarhs = st_data(1,("initiall","initialk"))
    
    OMEGA=PHI-X*betas' 
	OMEGA_lag=PHI_LAG-X_lag*betarhs'
	
    OMEGA_lag_pol= (OMEGA_lag)
	g_b = invsym(OMEGA_lag_pol'OMEGA_lag_pol)*OMEGA_lag_pol'OMEGA
	XI=OMEGA-OMEGA_lag_pol*g_b
	
	mom1 = XI:*Z[.,1]
	mom2 = XI:*Z[.,2]
	mom3 = XI:*Z[.,3]
	mom = (mom1,mom2,mom3)
	vce = variance(mom)
	W = invsym(vce)/rows(Z)
	
	crit=(Z'XI)'*W*(Z'XI)
}

void DLW()
	{
initialvalue=st_data(1,("initiall","initialk"))
S=optimize_init()
optimize_init_evaluator(S, &GMM_DLW())
optimize_init_evaluatortype(S,"d0")
optimize_init_technique(S, "nm")
optimize_init_nmsimplexdeltas(S, 0.01)
optimize_init_which(S,"min")
optimize_init_params(S,initialvalue)

p=optimize(S)
f=optimize_result_value(S)
p
f
st_matrix("beta_dlw",(p,f))

    } 
end

capture program drop dlw	
program dlw, rclass
preserve 
sort id t
mata DLW()
end


