clear all
set more off

cd "F:\Research\RR"

/*The outside loop runs different Monte Carlo experiments: `original' denotes ACF Procedure with varying initial values;`augmented' denotes modified ACF with augmented instruments;`sequential' denotes modified ACF with sequential search*/
foreach mc in original augmented sequential{

forvalues i = 1(1)1000{
import delimited "F:\Research\RR\dgp`i'.csv", colrange(1:40) clear /*load simulated data for estimation*/

forvalues t = 1(1)10{
local i_k = `t'
rename v`i_k' k`t'

local i_l = 10 + `t'
rename v`i_l' l`t'

local i_m = 20 + `t'
rename v`i_m' m`t'

local i_y = 30 + `t'
rename v`i_y' y`t'
}

gen id = _n /*generate firm id*/
save dgp1_simulation.dta, replace


/*start estimation*/

local dlwprogram = "acf_mata_`mc'.do"

do `dlwprogram'

use dgp1_simulation.dta, clear 
reshape long k l m y, i(id) j(t)
xtset id t

*------FIRST STAGE  ----------------------------------------------------------*
xi: reg y l m k /*robust to higher order polynomial*/

predict phi
predict epsilon, res

label var phi "phi_it 
label var epsilon "measurement error first stage
gen phi_lag=L.phi
*----------------------------------------------------------------------------------------------------*
gen l_lag=L.l
gen k_lag=L.k
gen l_lag2=L.l_lag
*---------------------------------------------------------------------------------------------------*
sort id t
gen const=1
drop if y==.
drop if l_lag==.
drop if k==.
drop if k_lag==.
drop if l_lag2 == .
*----------------------------------------------------------------------------------------------------

*------TRY DIFFERENT STARTING VALUES-----------------------------------------------------------------
local starting = 10
gen initialConst = 0

forvalues s = 1(1)`starting'{
gen initiall = 0.1*(`s'-1)
gen initialk = 0.1*(11-`s')

dlw /*start search*/

putexcel A`s' = mat(beta_dlw) using acf_`mc', sheet("dgp1_`i'") modify /*save results to excel*/

drop initiall initialk
}

local i = `i' + 1
}

*step 3: IMPORT RESULTS TO STATA DATA FILE

import excel "F:\Research\RR\acf_`mc'.xlsx",sheet("dgp1_1") clear
sort C
keep if _n == 1
save result_acf_`mc'.dta, replace


local loop = 2

while `loop' < = 1000{

import excel "F:\Research\RR\acf_`mc'.xlsx",sheet("dgp1_`loop'") clear
sort C
keep if _n == 1
save result_temp.dta, replace

append using result_acf_`mc'.dta

save result_acf_`mc'.dta, replace 

local loop = `loop' + 1

}

} 
