% TCRATE_VDC_CHOL.M
clear;

% Load admissible posterior model estimates
load models_posterior0_chol;

% Shell for variance decompositions
num=size(z,1);
FEDCmat=zeros(num,n);

for r=1:num

    % Construct RF posterior parameters for jth admissible model   
    B      = (reshape(z(r,1:(1+n*p)*n),1+n*p,n))'; 
    B0inv      = reshape(z(r,(1+n*p)*n+n*n+1:(1+n*p)*n+2*n*n),n,n);
    
    % VDC in percentage terms at horizon h
    % Columns refer to shocks j=1,...,q that explain any given variable
    % Rows refer to variables whose variation is to be explained
    % Here we care about the last row (the stock return variable) and all
    % columns (i.e., the contribution of each shock)
    h=1000;
    J=[eye(n,n) zeros(n,n*(p-1))];
    TH1=J*[B(:,1+1:end);eye(n*(p-1)) zeros(n*(p-1),n)]^0*J'; TH=TH1*B0inv; TH=TH'; TH2=(TH.*TH); TH3=TH2;
    for i=2:h
        TH=J*[B(:,1+1:end);eye(n*(p-1)) zeros(n*(p-1),n)]^(i-1)*J'*B0inv; TH=TH'; TH2=(TH.*TH); TH3=TH3+TH2;
    end;
    TH4=sum(TH3);
    VC=zeros(n,n);
    for j=1:n
        VC(j,:)=TH3(j,:)./TH4;
    end;

    % Real time charter rate: variable 3
    FEVDC=VC'*100; FEVDC=FEVDC(3,:); 
    FEVDCmat(r,:)=FEVDC;
    if r==1
        FEVDC(1,1)
    end;    

end;
