% COUNTERFACTUAL_INFLEXP.M

clear;
load hd_inflexp;

% Michigan Survey of Consumers: Mean of 1yr inflation expectation 
load inflexp1yr_78_01.txt;
inflexp1yrmean=inflexp1yr_78_01(55:end,end-6);

% VAR based counterfactual inflation expectations
% Also used as raw input for Phillips curve analysis
counterfactual=inflexp1yrmean-yhat32(:,1); 
save counterfactual counterfactual; 

subplot(1,1,1)
plot(time,inflexp1yrmean,'k-',time,counterfactual,'r:','linewidth',3);
%title('Michigan Survey of Consumers Mean 1-Year Ahead Inflation Expectation','fontsize',18)
ylabel('Percent','fontsize',16)
axis([1990+1/12 time(end) 0 8])
grid on
legend('Actual','Counterfactual')


% 2009.1-2013.3
gascomponent=yhat32(:,1);
[inflexp1yrmean(369)-inflexp1yrmean(319);
 counterfactual(369)-counterfactual(319);
 gascomponent(369)-gascomponent(319)]

