% standardizes dataset X and extracts r principal components
function [pcs, loadings] = extractpcs(X,r)

if r>0
N = size(X, 2);
weights = ones(1,N);

WW = diag(std(X)./weights);
x = center(X)*(WW^-1);
Gamma0 = cov(x);
opt.disp = 0;
[loadings, ~] = eigs(Gamma0, r,'LM',opt);
pcs = x*loadings;
else
    pcs = [];
end