clearvars
close all
clc
addpath(genpath(pwd))

%% LOAD DATA
load('DATA.mat')

%% CREATE FIGURES
MainFigs123             % Figures 1-3
MainFigs4               % Figure 4
MainFigs5               % Figure 5

%% DATA DESCRIPTION
% "X" contains all macro data:
% .data         =   TxN dataset, see Table A1 in Online Appendix
% .data_var     =   same dataset, except IP & HICP in log-levels
% .tcode        =   Nx1 transformation codes (1: level, 4: log-level, 5: log-difference)
% .tcode_var    =   same codes, except IP & HICP in log-levels
% .dates        =   Tx1 monthly date vector
% .names        =   Nx1 variable namens
% .plotnames    =   Nx1 variable namens used in figures
%
% "extinst" contains Gertler & Karadi (2015)'s external instrument
% .FF4_data     =   monthly surprise series
% .FF4_dates    =   corresponding dates
%
% "opts" specifies various details
% .nboot        =   number of bootstrap draws
% .h            =   horizon of IRFs
% .mpind        =   'monetary policy indicator', i.e. the variable whose
%                   impact effect is set to a 50bp increase
% .header       =   column header for Figures 1-3
% .plotvars1    =   variables shown in Figures 1-3
% .plotvars2    =   variables shown in Figure 4&5
% 
% "opts.var" sets the benchmark specification of the VAR and FAVAR
% .r_favar      =   number of factors added to observable variables in FAVAR
% .phat         =   lag length
%
% "opts.dfm" sets the benchmark specification of the DFM
% .rhat         =   number of 'static' factors
% .qhat         =   number of 'dynamic' factors
% .phat         =   lag length