% plot IRFs for Dynamic Factor Model
% with Cholesky identification
% and Ext.Inst. identification
% for full sample and pre-crisis sample

samp(1,:) = [datenum(1973,4,1) datenum(2016,9,30)]; % full sample
samp(2,:) = [datenum(1973,4,1) datenum(2008,6,30)]; % pre-crisis


for i_s=1:2 % full sample and precisis sample

Xcur = struct;
Xcur.tcode = X.tcode;
Xcur.names = X.names;
Xcur.plotnames = X.plotnames;

Xcur.dates = X.dates(X.dates>=samp(i_s,1) & X.dates<=samp(i_s,2),:);
Xcur.data = X.data(X.dates>=samp(i_s,1) & X.dates<=samp(i_s,2),:);

IRFextinst = NaN(opts.N,opts.h+1,3,3);
IRFchol = NaN(opts.N,opts.h+1,3,3);
IRFchol_b = NaN(opts.N,opts.h+1,opts.nboot);
IRFextinst_b = NaN(size(IRFchol_b));


[BB_dfm, Chi, rsh, DFM] = DFMest(Xcur.data,opts);
% Cholesky
[IRFchol(:,:,2)] = IdentChol(BB_dfm,rsh,Xcur.tcode,Xcur.names,opts.plotvars2,opts.mpind);  
% Ext.Inst.
[rsh_sel_ind, inst_sel] = selextinstsample(Xcur,rsh,extinst,'FF4');
[IRFextinst(:,:,2)] = IdentExtInstr(BB_dfm,Xcur.tcode, Xcur.names,opts,rsh(rsh_sel_ind,:), inst_sel);  
% Bootstrap
[BB_dfm_b, rsh_dfm_b, rrdfm_b] = DFMest_boot(Xcur.data,opts);
for i_b=1:opts.nboot
    [IRFchol_b(:,:,i_b)] = IdentChol(BB_dfm_b(:,:,:,i_b),rsh_dfm_b(:,:,i_b),Xcur.tcode,Xcur.names,opts.plotvars2,opts.mpind);  
    [rsh_sel_ind_b, inst_sel_b] = selextinstsample(Xcur,rsh_dfm_b(:,:,i_b),extinst,'FF4',rrdfm_b(:,i_b));
    [IRFextinst_b(:,:,i_b)] = IdentExtInstr(BB_dfm_b(:,:,:,i_b), Xcur.tcode, Xcur.names, opts, rsh_dfm_b(rsh_sel_ind_b,:,i_b), inst_sel_b);
end
IRFchol(:,:,1) = prctile(IRFchol_b,5,3);
IRFchol(:,:,3) = prctile(IRFchol_b,95,3);
IRFextinst(:,:,1) = prctile(IRFextinst_b,5,3);
IRFextinst(:,:,3) = prctile(IRFextinst_b,95,3);

figure;
for i=1:length(opts.plotvars2)
    subplot(2,4,i); 
    plotarea(squeeze(IRFchol(getind(Xcur.names,opts.plotvars2(i)),:,:)),opts); hold on;
    title(Xcur.plotnames(getind(Xcur.names,opts.plotvars2(i))))
    plot(squeeze(IRFextinst(getind(Xcur.names,opts.plotvars2(i)),:,2)),'color','b','linestyle','--')
    plot(squeeze(IRFextinst(getind(Xcur.names,opts.plotvars2(i)),:,[1 3])),'color','b','linestyle','-.')
    grid on
end
end