% plot IRFs for Ext.Inst. FAVAR with different numbers of factors
% benchmark specification is r=9
% "too few" factors: r=[1,2,3]
% "enough" factors: r=[7,11,13]

npcs = [1:3 7 11 13];


%% reproduce benchmark specification, including confidence bands
IRFfavar_eii = NaN(opts.N,opts.h+1,3);
[BB_var, ~, rsh_var] = FAVARest(X.data_var, [X.data_var(:,getind(X.names,opts.plotvars1{1})) extractpcs(X.data,opts.var.r_favar)], opts);
[rsh_sel_ind, inst_sel] = selextinstsample(X,rsh_var,extinst,'FF4');
[IRFfavar_eii(:,:,2)] = IdentExtInstr(BB_var, X.tcode_var, X.names, opts, rsh_var(rsh_sel_ind,:), inst_sel);
% bootstrap
IRFeiifavar_b = NaN(opts.N,opts.h+1,opts.nboot);
[BB_favar_b, rsh_favar_b, rrfavar_b] = FAVARest_boot(X.data_var, [X.data_var(:,getind(X.names,opts.plotvars1{1})) extractpcs(X.data,opts.var.r_favar)], opts, getind(X.names,opts.plotvars1{1}));
for i_b=1:opts.nboot
    [rsh_sel_ind_b, inst_sel_b] = selextinstsample(X,rsh_favar_b(:,:,i_b),extinst,'FF4',rrfavar_b(:,i_b));
    [IRFeiifavar_b(:,:,i_b)] = IdentExtInstr(BB_favar_b(:,:,:,i_b), X.tcode_var, X.names, opts, rsh_favar_b(rsh_sel_ind_b,:,i_b), inst_sel_b);
end
IRFfavar_eii(:,:,1) = prctile(IRFeiifavar_b,5,3);
IRFfavar_eii(:,:,3) = prctile(IRFeiifavar_b,95,3);

%% point estimates for other number of factors
IRFfavar_eii_oth = NaN(opts.N,opts.h+1,length(npcs));
for i=1:length(npcs)
[BB_var, ~, rsh_var] = FAVARest(X.data_var, [X.data_var(:,getind(X.names,opts.plotvars1{1})) extractpcs(X.data,npcs(i))], opts);
[rsh_sel_ind, inst_sel] = selextinstsample(X,rsh_var,extinst,'FF4');
[IRFfavar_eii_oth(:,:,i)] = IdentExtInstr(BB_var, X.tcode_var, X.names, opts, rsh_var(rsh_sel_ind,:), inst_sel);
end

%% Figure
for i=1:length(opts.plotvars2)
    subplot(2,4,i);
    plotarea(squeeze(IRFfavar_eii(getind(X.names,opts.plotvars2(i)),:,:)),opts); hold on;
    title(X.plotnames(getind(X.names,opts.plotvars2(i))))
    plot(squeeze(IRFfavar_eii_oth(getind(X.names,opts.plotvars2(i)),:,1:3)),'color','r','linestyle',':')
    plot(squeeze(IRFfavar_eii_oth(getind(X.names,opts.plotvars2(i)),:,4:end)),'color','b','linestyle','--')
    grid on
end
