% plot IRFs for
% 1) sequential VARs (Cholesky)
% 2) sequential VARs (Ext.Inst)
% 3) Ext.Inst. FAVAR
% 4) Cholesky DFM

IRF = struct;
IRF.var_cho = NaN(opts.N,opts.h+1,3);
IRF.var_eii = NaN(size(IRF.var_cho));
IRF.dfm_cho = NaN(size(IRF.var_cho));
IRF.dfm_eii = NaN(size(IRF.var_cho));
IRF.favar_eii = NaN(size(IRF.var_cho));

IRFchol_b =     NaN(opts.N,opts.h+1,opts.nboot);
IRFeiivar_b =   NaN(size(IRFchol_b));
IRFeiifavar_b = NaN(size(IRFchol_b));
IRFcholdfm_b =  NaN(size(IRFchol_b));
IRFcholeii_b =  NaN(size(IRFchol_b));

%% 1 & 2) sequentially estimate VARs, adding one variable of interest at a time
fourthvars = [opts.plotvars1{2} opts.plotvars1{3}];
for i_m = 1:length(fourthvars)
    [BB_var, ~, rsh_var] = FAVARest(X.data_var, X.data_var(:,getind(X.names,[opts.plotvars1{1},fourthvars(i_m)])), opts);
    % Cholesky
    [tempirfchol] = IdentChol(BB_var,rsh_var,X.tcode_var,X.names,[opts.plotvars1{1},fourthvars(i_m)],opts.mpind);        
    % External Instrument
    [rsh_sel_ind, inst_sel] = selextinstsample(X,rsh_var,extinst,'FF4');
    [tempirfextinst] = IdentExtInstr(BB_var, X.tcode_var, X.names, opts, rsh_var(rsh_sel_ind,:), inst_sel);
    % Bootstrap
    [BB_var_b, rsh_var_b, rrvar_b] = FAVARest_boot(X.data_var, X.data_var(:,getind(X.names,[opts.plotvars1{1},fourthvars(i_m)])), opts, getind(X.names,[opts.plotvars1{1},fourthvars(i_m)]));
    for i_b=1:opts.nboot
        [IRFchol_b(:,:,i_b)] = IdentChol(BB_var_b(:,:,:,i_b),rsh_var_b(:,:,i_b),X.tcode_var,X.names,opts.plotvars2,opts.mpind);   
        [rsh_sel_ind_b, inst_sel_b] = selextinstsample(X,rsh_var_b(:,:,i_b),extinst,'FF4',rrvar_b(:,i_b));
        [IRFeiivar_b(:,:,i_b)] = IdentExtInstr(BB_var_b(:,:,:,i_b), X.tcode_var, X.names, opts, rsh_var_b(rsh_sel_ind_b,:,i_b), inst_sel_b);
    end

if i_m ==1  % for first 3 variables (CPI, IP, GS1), keep IRFs with EBP as 4th variable
    IRF.var_cho(:,:,2) = tempirfchol;
    IRF.var_cho(:,:,1) = prctile(IRFchol_b,5,3);
	IRF.var_cho(:,:,3) = prctile(IRFchol_b,95,3);    
    IRF.var_eii(:,:,2) = tempirfextinst;
    IRF.var_eii(:,:,1) = prctile(IRFeiivar_b,5,3);
	IRF.var_eii(:,:,3) = prctile(IRFeiivar_b,95,3);
else        % for other varianles, save only current IRF
    IRF.var_cho(getind(X.names,fourthvars(i_m)),:,2) = tempirfchol(getind(X.names,fourthvars(i_m)),:);
    IRF.var_cho(getind(X.names,fourthvars(i_m)),:,1) = prctile(IRFchol_b(getind(X.names,fourthvars(i_m)),:,:),5,3);
	IRF.var_cho(getind(X.names,fourthvars(i_m)),:,3) = prctile(IRFchol_b(getind(X.names,fourthvars(i_m)),:,:),95,3);
    IRF.var_eii(getind(X.names,fourthvars(i_m)),:,2) = tempirfextinst(getind(X.names,fourthvars(i_m)),:);
    IRF.var_eii(getind(X.names,fourthvars(i_m)),:,1) = prctile(IRFeiivar_b(getind(X.names,fourthvars(i_m)),:,:),5,3);
	IRF.var_eii(getind(X.names,fourthvars(i_m)),:,3) = prctile(IRFeiivar_b(getind(X.names,fourthvars(i_m)),:,:),95,3);
end
end

%% 3) Ext.Inst. FAVAR
[BB_var, ~, rsh_var] = FAVARest(X.data_var, [X.data_var(:,getind(X.names,opts.plotvars1{1})) extractpcs(X.data,opts.var.r_favar)], opts);
[rsh_sel_ind, inst_sel] = selextinstsample(X,rsh_var,extinst,'FF4');
[IRF.favar_eii(:,:,2)] = IdentExtInstr(BB_var, X.tcode_var, X.names, opts, rsh_var(rsh_sel_ind,:), inst_sel);
% Bootstrap
[BB_favar_b, rsh_favar_b, rrfavar_b] = FAVARest_boot(X.data_var, [X.data_var(:,getind(X.names,opts.plotvars1{1})) extractpcs(X.data,opts.var.r_favar)], opts, getind(X.names,opts.plotvars1{1}));
for i_b=1:opts.nboot
    [rsh_sel_ind_b, inst_sel_b] = selextinstsample(X,rsh_favar_b(:,:,i_b),extinst,'FF4',rrfavar_b(:,i_b));
    [IRFeiifavar_b(:,:,i_b)] = IdentExtInstr(BB_favar_b(:,:,:,i_b), X.tcode_var, X.names, opts, rsh_favar_b(rsh_sel_ind_b,:,i_b), inst_sel_b);
end
IRF.favar_eii(:,:,1) = prctile(IRFeiifavar_b,5,3);
IRF.favar_eii(:,:,3) = prctile(IRFeiifavar_b,95,3);

%% 4) Cholesky DFM
[BB_dfm, Chi, rsh, DFM] = DFMest(X.data,opts);
[IRF.dfm_cho(:,:,2)] = IdentChol(BB_dfm,rsh,X.tcode,X.names,opts.plotvars2,opts.mpind);  
% Bootstrap
[BB_dfm_b, rsh_dfm_b, rrdfm_b] = DFMest_boot(X.data,opts);
for i_b=1:opts.nboot
    [IRFcholdfm_b(:,:,i_b)] = IdentChol(BB_dfm_b(:,:,:,i_b),rsh_dfm_b(:,:,i_b),X.tcode,X.names,opts.plotvars2,opts.mpind); 
end
IRF.dfm_cho(:,:,1) = prctile(IRFcholdfm_b,5,3);
IRF.dfm_cho(:,:,3) = prctile(IRFcholdfm_b,95,3);

%% Figures
for j=1:3
    figure;
    ax = gobjects(length(opts.plotvars1{j}),4);
for i=1:length(opts.plotvars1{j})
    % plot IRFs
    ax(i,1) = subplot(length(opts.plotvars1{j}),length(opts.header),(i-1)*length(opts.header)+1);     
    plotarea(squeeze(IRF.var_cho(getind(X.names,opts.plotvars1{j}(i)),:,:)),opts); 
    ylabel(X.plotnames(getind(X.names,opts.plotvars1{j}(i))),'Units','normalized','position',[-.15 0.5 0])    
    ax(i,2) = subplot(length(opts.plotvars1{j}),length(opts.header),(i-1)*length(opts.header)+2); 
    plotarea(squeeze(IRF.var_eii(getind(X.names,opts.plotvars1{j}(i)),:,:)),opts); 
    ax(i,3) = subplot(length(opts.plotvars1{j}),length(opts.header),(i-1)*length(opts.header)+3); 
    plotarea(squeeze(IRF.dfm_cho(getind(X.names,opts.plotvars1{j}(i)),:,:)),opts);    
    ax(i,4) = subplot(length(opts.plotvars1{j}),length(opts.header),(i-1)*length(opts.header)+4); 
    plotarea(squeeze(IRF.favar_eii(getind(X.names,opts.plotvars1{j}(i)),:,:)),opts);   
    % harmonize scales, turn on grid and label columns
    for ii = 1:4; axis tight; grid(ax(i,ii),'on'); end   
    linkaxes(ax(i,:),'xy')
    if i == 1; for ii=1:length(opts.header); title(ax(i,ii),opts.header(ii),'Units','normalized','position',[0.5 1.1 0]); end; end
end
end
