% identification (of mon pol shock) with external instrument, cf. Gertler & Karadi code
function [imp_mp_std_cum] = IdentExtInstr(rawimp, tcode, names, opts, rsh, Z)

% demean reduced form shocks and regress on instrument
rsh_mean0 = rsh-repmat(mean(rsh),size(Z,1),1);
H = (Z\rsh_mean0)';

imp_mp = NaN(size(rawimp,1),size(rawimp,3));
for j =  1:opts.h+1
    imp_mp(:,j) = rawimp(:,:,j)*H;
end

imp_mp_std = imp_mp./imp_mp(getind(names,opts.mpind),1)*.5;
imp_mp_std_cum = cumimp(imp_mp_std,tcode);

end