% Code is based on Forni & Gambetti (2010): 'DfmCholIdent.m'
% available at http://pareto.uab.es/lgambetti/ReplicaForniGambettiJME.zip

function [imp_mp_std_cum, sh_mp] = IdentChol(rawimp,rsh,tcode,names,selvars,mpindvar)

variables = getind(names,selvars(1:size(rsh,2)));

q = length(variables);
B0 = rawimp(variables,1:q,1);
C = chol(B0*B0')';
H = B0\C;

for j =  1:size(rawimp,3)
    imp(:,:,j) = rawimp(:,:,j)*H;
end

sh = rsh*H;

mp_pos = find(variables==getind(names,mpindvar));
imp_mp = squeeze(imp(:,mp_pos,:));
sh_mp = sh(:,mp_pos);

imp_mp_std = imp_mp./imp_mp(getind(names,mpindvar),1)*.5;
imp_mp_std_cum = cumimp(imp_mp_std,tcode);
