function [B, rsh, rr]  = FAVARest_boot(X, Z, opts, variables)

p = opts.var.phat;
h = opts.h;

N = size(X, 2);
T = size(X, 1);

B = NaN(N,size(Z,2),h+1,opts.nboot);
rsh = NaN(T-p,size(Z,2),opts.nboot);
rr = NaN(T-p,opts.nboot);

W = [ones(T,1) Z];
AA = (W'*W)\W'*X;
chi = W*AA;
A = AA(2:end,:);

Idio = X-chi;
IdioBoot = NaN([size(Idio),opts.nboot]);

RHS      = lagmatrix(Z,1:p);
RHS(1:p,:) = [];

LHS      = Z(p+1:end,:);
VAR.bet = [RHS ones(length(RHS),1)]\LHS; 
VAR.res = LHS-[RHS ones(length(RHS),1)]*VAR.bet;

res = VAR.res-repmat(mean(VAR.res),size(VAR.res,1),1);

%% wild bootstrap procedure
% cf. Gertler & Karadi (2015) and Mertens & Ravn (2013)

for j=1:opts.nboot  
    Z_boot = zeros(p+size(LHS,1),size(LHS,2));
    Z_boot(1:p,:)=Z(1:p,:);
    rr(:,j) = 1-2*(rand(size(LHS,1),1)>0.5);
    resb = (res.*(rr(:,j)*ones(1,size(LHS,2))))';
            
        for jj=p+1:p+size(LHS,1)
            lvars = (Z_boot(jj-1:-1:jj-p,:))';
            Z_boot(jj,:) = lvars(:)'*VAR.bet(1:p*size(LHS,2),:)+VAR.bet(p*size(LHS,2)+1:end,:)+resb(:,jj-p)';
        end
    
        for i=1:size(Idio,2)
            if ismember(i,variables)~=1
                % estimate AR(4) on idio part
                [tempIRFidio, epsilon, ~] = woldimpulse(Idio(:,i), 4, 50, 1);
                IRFidio = squeeze(tempIRFidio); 
                % draw idio part from normal dist
                epsilon_boot = normrnd(0,std(epsilon),size(IdioBoot,1),1); 
                tempidio_boot = filter(IRFidio,1,epsilon_boot);
                IdioBoot(:,i,j) = tempidio_boot(1:end);
            else
                IdioBoot(:,i,j) = zeros(size(IdioBoot,1),1);
            end
        end
        
    W_boot = [ones(size(Z,1),1) Z_boot];    
    X_boot = W_boot*AA + IdioBoot(:,:,j);    
    [B(:,:,:,j), ~,rsh(:,:,j)] = FAVARest(X_boot, Z_boot, opts);
end