% Code is based on Forni, Gambetti, Sala (2014): 'FAVARRaw.m'
% available at https://onlinelibrary.wiley.com/action/downloadSupplement?doi=10.1111%2Fecoj.12111&attachmentId=193737733

function [B, chi, rsh]  = FAVARest(X, Z, opts)

p = opts.var.phat;
h = opts.h;

N = size(X, 2);
T = size(X, 1);

B = NaN(N,size(Z,2),h+1);

W = [ones(T,1) Z];
AA = (W'*W)\W'*X;
chi = W*AA;
A = AA(2:end,:);
[BB, epsilon, ~] = woldimpulse(Z, p, h + 1);
Sigma = cov(epsilon);
C = chol(Sigma)';
for lag = 1 : h + 1
    B(:, :, lag) = A'*BB(:, :, lag)*C; 
end
rsh = epsilon/C';
