
function [B_b, rsh, rr]  = DFMest_boot(X, opts)

q = opts.dfm.qhat;
r = opts.dfm.rhat;
p = opts.dfm.phat;
h = opts.h;
N = size(X, 2);
T = size(X, 1);

B_b = NaN(N,q,h+1,opts.nboot);
rsh = NaN(T-p,q,opts.nboot);
rr = NaN(T-p,opts.nboot);

weights = ones(1,N);

WW = diag(std(X)./weights);
x = center(X)*(WW^-1);
Gamma0 = cov(x);
opt.disp = 0;
[W, ~] = eigs(Gamma0, r,'LM',opt);
F = x*W;
chi = F*W';
Chi = chi*WW + ones(T,1)*mean(X);
[BB, epsilon, ~] = woldimpulse(F, p, h + 1, 1);
Sigma = cov(epsilon);
[ K, MM ] = eigs(Sigma, q, 'LM',opt);
M = diag(sqrt(diag(MM)));
for lag = 1 : h + 1
    B(:, :, lag) = WW*W*BB(:, :, lag)*K*M;
end
rsh = epsilon*K/M;

rsh = rsh-repmat(mean(rsh),size(rsh,1),1);

RHS      = lagmatrix(F,1:p);
RHS(1:p,:) = [];
LHS      = F(p+1:end,:);
bet = [RHS ones(length(RHS),1)]\LHS; 

Idio = X-Chi;
IdioBoot = NaN(size(Idio));

%% wild bootstrap procedure
% cf. Gertler & Karadi (2015) and Mertens & Ravn (2013)

for j=1:opts.nboot  
    
    rr(:,j) = 1-2*(rand(T-p,1)>0.5);
    resb = (epsilon.*(rr(:,j)*ones(1,r)));    

    
    F_boot = zeros(p+size(LHS,1),size(LHS,2));
    F_boot(1:p,:)=F(1:p,:);
    for jj=p+1:p+size(LHS,1)
        lvars = (F_boot(jj-1:-1:jj-p,:))';
        F_boot(jj,:) = lvars(:)'*bet(1:p*size(LHS,2),:)+bet(p*size(LHS,2)+1:end,:)+resb(jj-p,:);
    end
    Chi_boot = (F_boot*W')*WW + ones(T,1)*mean(X);   
    
        % Bootstrap idiosyncratic errors, cf. Stock & Watson, Handbook of Macro 2
        for i=1:N                         
            % estimate AR(4) on idio part            
            [tempIRFidio, eta, ~] = woldimpulse(Idio(:,i), 4, 50, 1);
            IRFidio = squeeze(tempIRFidio); 
            % draw idio part from normal dist
            epsilon_boot = normrnd(0,std(eta),T,1); 
            tempidio_boot = filter(IRFidio,1,epsilon_boot);
            IdioBoot(:,i) = tempidio_boot(1:end);
        end 
    X_boot = Chi_boot + IdioBoot;

[B_b(:,:,:,j), ~,rsh(:,:,j)] = DFMest(X_boot,opts);
end