% Code is based on Forni & Gambetti (2010): 'DfmRawImp.m'
% available at http://pareto.uab.es/lgambetti/ReplicaForniGambettiJME.zip

function [B, Chi, rsh, DFM]  = DFMest(X, opts)

q = opts.dfm.qhat;
r = opts.dfm.rhat;
p = opts.dfm.phat;
h = opts.h;

N = size(X, 2);
weights = ones(1,N);
T = size(X, 1);
WW = diag(std(X)./weights);
x = center(X)*(WW^-1);
Gamma0 = cov(x);
opt.disp = 0;
[W, ~] = eigs(Gamma0, r,'LM',opt);
F = x*W;
chi = F*W';
Chi = chi*WW + ones(T,1)*mean(X);
[BB, epsilon, ~] = woldimpulse(F, p, h + 1, 1);
Sigma = cov(epsilon);
[ K, MM ] = eigs(Sigma, q, 'LM',opt);
M = diag(sqrt(diag(MM)));

%% get OLS coeffs for wild bootstrap
DFM.RHS      = lagmatrix(F,1:p);
DFM.RHS      = DFM.RHS(p+1:end,:);
DFM.LHS      = F(p+1:end,:);
DFM.bet = [DFM.RHS ones(length(DFM.RHS),1)]\DFM.LHS; 
DFM.res = DFM.LHS-[DFM.RHS ones(length(DFM.RHS),1)]*DFM.bet;
DFM.F = F;
DFM.betq = DFM.bet*K*M;
%%

for lag = 1 : h + 1
    B(:, :, lag) = WW*W*BB(:, :, lag)*K*M;    
end
rsh = epsilon*K/M;