% This program selects the number of factors for the pooled and
% heterogeneous IFE estimators based on the appraoch in Bai and Ng (2002) 
% of estimating the ICp1 value for each set of r=1-10 results and selecting 
% the lowest.

% Note that the code provided for the replication only estimates the IFE 
% estimators ("FMestimation[...].m") for the number of factors used in 
% the paper, so this program is not called in the replication master file.
% However, that number was chosen based on the results from this program. 
% To replicate the factor selection, edit FMestimation[...].m to estimate 
% IFE based on 1-10 factors, then run this program.

clear
LASTN=maxNumCompThreads(12)
addpath('matlabprograms')
addpath('../mydata')

load('../mydata/results_saa2a4BOTH2_tFE1ch.mat')


%select r based on minimmizing penalized SSR over k
%pooled
Uife1_2=Uife1.^2;
Uife2_2=Uife2.^2;
Uife3_2=Uife3.^2;
Uife4_2=Uife4.^2;
Uife5_2=Uife5.^2;
Uife6_2=Uife6.^2;
Uife7_2=Uife7.^2;
Uife8_2=Uife8.^2;
Uife9_2=Uife9.^2;
Uife10_2=Uife10.^2;
meanUife1=mean(Uife1_2(:));
meanUife2=mean(Uife2_2(:));
meanUife3=mean(Uife3_2(:));
meanUife4=mean(Uife4_2(:));
meanUife5=mean(Uife5_2(:));
meanUife6=mean(Uife6_2(:));
meanUife7=mean(Uife7_2(:));
meanUife8=mean(Uife8_2(:));
meanUife9=mean(Uife9_2(:));
meanUife10=mean(Uife10_2(:));

gNT=((N+T)/(N*T))*log((N*T)/(N+T));

ICp1_1=log(meanUife1)+1*gNT;
ICp1_2=log(meanUife2)+2*gNT;
ICp1_3=log(meanUife3)+3*gNT;
ICp1_4=log(meanUife4)+4*gNT;
ICp1_5=log(meanUife5)+5*gNT;
ICp1_6=log(meanUife6)+6*gNT;
ICp1_7=log(meanUife7)+7*gNT;
ICp1_8=log(meanUife8)+8*gNT;
ICp1_9=log(meanUife9)+9*gNT;
ICp1_10=log(meanUife10)+10*gNT;


%heterogeneous
Uifei1_2=Uifei1.^2;
Uifei2_2=Uifei2.^2;
Uifei3_2=Uifei3.^2;
Uifei4_2=Uifei4.^2;
Uifei5_2=Uifei5.^2;
Uifei6_2=Uifei6.^2;
Uifei7_2=Uifei7.^2;
Uifei8_2=Uifei8.^2;
Uifei9_2=Uifei9.^2;
Uifei10_2=Uifei10.^2;
meanUifei1=mean(Uifei1_2(:));
meanUifei2=mean(Uifei2_2(:));
meanUifei3=mean(Uifei3_2(:));
meanUifei4=mean(Uifei4_2(:));
meanUifei5=mean(Uifei5_2(:));
meanUifei6=mean(Uifei6_2(:));
meanUifei7=mean(Uifei7_2(:));
meanUifei8=mean(Uifei8_2(:));
meanUifei9=mean(Uifei9_2(:));
meanUifei10=mean(Uifei10_2(:));

ICp1i_1=log(meanUifei1)+1*gNT;
ICp1i_2=log(meanUifei2)+2*gNT;
ICp1i_3=log(meanUifei3)+3*gNT;
ICp1i_4=log(meanUifei4)+4*gNT;
ICp1i_5=log(meanUifei5)+5*gNT;
ICp1i_6=log(meanUifei6)+6*gNT;
ICp1i_7=log(meanUifei7)+7*gNT;
ICp1i_8=log(meanUifei8)+8*gNT;
ICp1i_9=log(meanUifei9)+9*gNT;
ICp1i_10=log(meanUifei10)+10*gNT;



save('../mydata/results_saa2a4BOTH2_tFE1ch.mat')


