/*This program produces the two figures in the paper: 
	1. The distribution of individual-level returns for each estimator
	2. Decompmosition of the aggregate least squares bias
*/

log using ${dopath}/p7_figures.log, replace



*****************************
* 1. create bias decomposition graph
* NOTE, this code produces the main plot. I then edited the graph to make it look "prettier".
* ALSO NOTE, the user needs to manually fill in the 7 numbers at the beginning
*	of this section to run the code. These numbers come from Table 3, 4, and 5.
*****************************
clear

*fill in the below local macros manually with the results from tables 3, 4 and 5
local olsp=0.077
local ifep=0.020
local ifemg=0.028
local ccep=0.038
local ccemg=0.044
local cce2p=0.023
local cce2mg=0.041

local ife_abilitybias=`olsp'-`ifep'
local cce_abilitybias=`olsp'-`ccep'
local cce2_abilitybias=`olsp'-`cce2p'

local ife_heterobias=`ifep'-`ifemg'
local cce_heterobias=`ccep'-`ccemg'
local cce2_heterobias=`cce2p'-`cce2mg'

set obs 12
gen estimator=1 in 1
replace estimator=1 in 2
replace estimator=1 in 3
replace estimator=1 in 4
replace estimator=2 in 5
replace estimator=2 in 6
replace estimator=2 in 7
replace estimator=2 in 8
replace estimator=3 in 9
replace estimator=3 in 10
replace estimator=3 in 11
replace estimator=3 in 12
gen component=1 in 1
replace component=2 in 2
replace component=3 in 3
replace component=4 in 4
replace component=1 in 5
replace component=2 in 6
replace component=3 in 7
replace component=4 in 8
replace component=1 in 9
replace component=2 in 10
replace component=3 in 11
replace component=4 in 12
gen amount=.
replace amount=`olsp' if component==1
replace amount=`ife_abilitybias' if estimator==1 & component==2
replace amount=`ife_heterobias' if estimator==1 & component==3
replace amount=`ifemg' if estimator==1 & component==4
replace amount=`cce_abilitybias' if estimator==2 & component==2
replace amount=`cce_heterobias' if estimator==2 & component==3
replace amount=`ccemg' if estimator==2 & component==4
replace amount=`cce2_abilitybias' if estimator==3 & component==2
replace amount=`cce2_heterobias' if estimator==3 & component==3
replace amount=`cce2mg' if estimator==3 & component==4

graph hbar (sum) amount, over(component) asyvars blabel(bar, position(center) format(%9.3f)) by(estimator, c(1))
graph save ${outputpath}/Figure1.gph, replace





*****************************
* 2. individual returns distribution graph 
* NOTE, this code produces the main plot. I then edited the graph to make it look "prettier".
*****************************
use ${mydatapath}/heteroreturns.dta, clear
twoway (kdensity bi_ols if bi_ols>=-.5 & bi_ols<=.5 & year==1990, kernel(gau) bw(.05)) (kdensity bi_ife if bi_ife>=-.5 & bi_ife<=.5 & year==1990, kernel(gau) bw(.050)) (kdensity bi_cce if bi_cce>=-.5 & bi_cce<=.5 & year==1990, kernel(gau) bw(.050)) (kdensity bi_cce2 if bi_cce2>=-.5 & bi_cce2<=.5 & year==1990, kernel(gau) bw(.05)) 
graph save ${outputpath}/Figure2.gph, replace



log close
