/*
This program executes the Matlab factor model estimation.

It produces Table 4, Table 5, Table D2, and Table D3.
It also produces the CD test statistics that go with 
	Table 3 and Table D1.
It also exports the individual beta_i coefficients 
	for further analysis in Stata.
*/

log using ${dopath}/p5_FM_master.log, replace


* Run matlab programs
* Factor Model estimation
shell matlab -nosplash -nodisplay -nodesktop -r "try; run('FMestimation_saa2_iFE1ch.m'); catch; end; quit" > FMestimation_saa2_iFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('FMestimation_saa2_tFE1ch.m'); catch; end; quit" > FMestimation_saa2_tFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('FMestimation_ss2aa2_iFE2ch.m'); catch; end; quit" > FMestimation_ss2aa2_iFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('FMestimation_ss2aa2_tFE2ch.m'); catch; end; quit" > FMestimation_ss2aa2_tFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('FMestimation_saa2a4_iFE1ch.m'); catch; end; quit" > FMestimation_saa2a4_iFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('FMestimation_saa2a4_tFE1ch.m'); catch; end; quit" > FMestimation_saa2a4_tFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('FMestimation_ss2aa2a4_iFE2ch.m'); catch; end; quit" > FMestimation_ss2aa2a4_iFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('FMestimation_ss2aa2a4_tFE2ch.m'); catch; end; quit" > FMestimation_ss2aa2a4_tFE2ch.log


*Cross-section Dependence tests
shell matlab -nosplash -nodisplay -nodesktop -r "try; run('CDstats_saa2_iFE1ch.m'); catch; end; quit" > CDstats_saa2_iFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('CDstats_saa2_tFE1ch.m'); catch; end; quit" > CDstats_saa2_tFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('CDstats_ss2aa2_iFE2ch.m'); catch; end; quit" > CDstats_ss2aa2_iFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('CDstats_ss2aa2_tFE2ch.m'); catch; end; quit" > CDstats_ss2aa2_tFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('CDstats_saa2a4_iFE1ch.m'); catch; end; quit" > CDstats_saa2a4_iFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('CDstats_saa2a4_tFE1ch.m'); catch; end; quit" > CDstats_saa2a4_tFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('CDstats_ss2aa2a4_iFE2ch.m'); catch; end; quit" > CDstats_ss2aa2a4_iFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('CDstats_ss2aa2a4_tFE2ch.m'); catch; end; quit" > CDstats_ss2aa2a4_tFE2ch.log

/*
*IFE/IFEMG number of factors selection (excluded from replication, because only final number of factors used in papers are used in replication)
shell matlab -nosplash -nodisplay -nodesktop -r "try; run('rselection_saa2_iFE1ch.m'); catch; end; quit" > rselection_saa2_iFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('rselection_saa2_tFE1ch.m'); catch; end; quit" > rselection_saa2_tFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('rselection_ss2aa2_iFE2ch.m'); catch; end; quit" > rselection_ss2aa2_iFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('rselection_ss2aa2_tFE2ch.m'); catch; end; quit" > rselection_ss2aa2_tFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('rselection_saa2a4_iFE1ch.m'); catch; end; quit" > rselection_saa2a4_iFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('rselection_saa2a4_tFE1ch.m'); catch; end; quit" > rselection_saa2a4_tFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('rselection_ss2aa2a4_iFE2ch.m'); catch; end; quit" > rselection_ss2aa2a4_iFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('rselection_ss2aa2a4_tFE2ch.m'); catch; end; quit" > rselection_ss2aa2a4_tFE2ch.log
*/

*Slope homogeneity tests for the heterogeneous coefficient factor model estimators
shell matlab -nosplash -nodisplay -nodesktop -r "try; run('Slopetests_saa2_iFE1ch.m'); catch; end; quit" > Slopetests_saa2_iFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('Slopetests_ss2aa2_iFE2ch.m'); catch; end; quit" > Slopetests_ss2aa2_iFE2ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('Slopetests_saa2a4_iFE1ch.m'); catch; end; quit" > Slopetests_saa2a4_iFE1ch.log

shell matlab -nosplash -nodisplay -nodesktop -r "try; run('Slopetests_ss2aa2a4_iFE2ch.m'); catch; end; quit" > Slopetests_ss2aa2a4_iFE2ch.log


*Write results to CSV tables and export individual beta_i's to csv to load into Stata for analysis
shell matlab -nosplash -nodisplay -nodesktop -r "try; run('FMtables.m'); catch; end; quit" > FMtables.log


log close
