/*
This program exports variables of interest to .xls files, so they can be 
	loaded into MATALB for estimation of the factor models.
*/


log using ${dopath}/p4_ExportMatlab.log, replace


local samples insampleBOTH2_1ch insampleBOTH2_2ch
local schoolvar educyears2

foreach sample of local samples {

*****************************************
* Export variables 
*****************************************
use ${mydatapath}/GSFadminlongDOA_19782011EarnRestrict.dta, clear
keep if `sample'==1 
keep log_total_der_cpi year personid
reshape wide log_total_der_cpi, i(personid) j(year)
drop personid
export excel using ${mydatapath}/GSFlogearn_`sample'.xls, sheetreplace

use ${mydatapath}/GSFadminlongDOA_19782011EarnRestrict.dta, clear
keep if `sample'==1 
keep `schoolvar' year personid
reshape wide `schoolvar', i(personid) j(year)
drop personid
export excel using ${mydatapath}/GSF`schoolvar'_`sample'.xls, sheetreplace

use ${mydatapath}/GSFadminlongDOA_19782011EarnRestrict.dta, clear
keep if `sample'==1 
keep ageq year personid
reshape wide ageq, i(personid) j(year)
drop personid
export excel using ${mydatapath}/GSFageq_`sample'.xls, sheetreplace


*personid, for merging beta_i's from factor model estimation into excel file to load back into Stata later for analysis
use ${mydatapath}/GSFadminlongDOA_19782011EarnRestrict.dta, clear
keep if `sample'==1 
keep `schoolvar' year personid
reshape wide `schoolvar', i(personid) j(year)
keep personid
export excel using ${mydatapath}/GSFpersonid_`sample'.xls, sheetreplace

}


log close
